package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportProtocolCaracteristicAction.java 1247 2013-09-28 12:15:25Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.6.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/ImportProtocolCaracteristicAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * To import protocol caracteristics.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportProtocolCaracteristicAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportProtocolCaracteristicAction.class);

    private File file;

    public ImportProtocolCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to import
            file = chooseFile(
                    _("tutti.editProtocol.title.choose.caracteristicImportFile"),
                    _("tutti.editProtocol.action.chooseProtocolCaracteristicFile"),
                    "^.*\\.csv", _("tutti.common.file.csv")
            );

            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull(file);
        if (log.isInfoEnabled()) {
            log.info("Will import protocol caracteristic file: " + file);
        }

        EditProtocolUIModel model = getModel();

        // bind to a protocol
        TuttiProtocol protocol = model.toBean();

        ProtocolImportExportService service =
                getContext().getTuttiProtocolImportExportService();

        service.importProtocolCaracteristic(file,
                                            protocol,
                                            model.getAllCaracteristic());

        handler.addDoubleListListeners();

        try {
            // rebind to model
            model.fromBean(protocol);
        } finally {
            handler.removeDoubleListListeners();
        }

        sendMessage(
                _("tutti.flash.info.caracteristic.imported.in.protocol",
                  file));

    }
}