package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id: ViewGearCaracteristicsAction.java 1252 2013-09-30 17:43:36Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.6.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/cruise/ViewGearCaracteristicsAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.1
 */
public class ViewGearCaracteristicsAction extends AbstractTuttiAction<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ViewGearCaracteristicsAction.class);

    protected final PersistenceService persistenceService;

    public ViewGearCaracteristicsAction(EditCruiseUIHandler handler) {
        super(handler, false);
        persistenceService = getContext().getPersistenceService();
    }

    @Override
    public void doAction() throws Exception {
        GearCaracteristicsEditorUI editor = getUI().getGearCaracteristicsEditor();
        editor.getModel().setEditable(false);

        Gear gear = getUI().getContextValue(Gear.class);
        gear = persistenceService.getGearWithCaracteristics(gear, getDataContext().getCruise());

        if (log.isInfoEnabled()) {
            log.info("Will view gear " + decorate(gear, DecoratorService.GEAR_WITH_RANK_ORDER));
        }

        editor.getModel().setGear(gear);

        getUI().getMainPanelLayout().setSelected(EditCruiseUIHandler.GEAR_CARACTERISTICS_CARD);
    }
}
