/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.gear;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class GearPopulationSelectivityModel
extends AbstractTableModel
implements TableCellRenderer,
SensitivityTableModel {
    private static Log log = LogFactory.getLog(GearPopulationSelectivityModel.class);
    private static final long serialVersionUID = 3169786638868209920L;
    public static final String[] COLUMN_NAMES = new String[]{I18n.t((String)"isisfish.common.population", (Object[])new Object[0]), I18n.t((String)"isisfish.common.equation", (Object[])new Object[0])};
    protected List<Selectivity> selectivities;

    public GearPopulationSelectivityModel() {
        this(null);
    }

    public GearPopulationSelectivityModel(List<Selectivity> selectivities) {
        this.selectivities = selectivities;
    }

    public void setSelectivities(List<Selectivity> selectivities) {
        this.selectivities = selectivities;
    }

    public List<Selectivity> getSelectivities() {
        return this.selectivities;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        int rows = 0;
        if (this.selectivities != null) {
            rows = this.selectivities.size();
        }
        return rows;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Selectivity selectivity = this.selectivities.get(rowIndex);
        return switch (columnIndex) {
            case 0 -> selectivity.getPopulation().getName();
            case 1 -> selectivity.getEquation();
            default -> throw new IndexOutOfBoundsException("No such column " + columnIndex);
        };
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> String.class;
            case 1 -> Equation.class;
            default -> throw new IndexOutOfBoundsException("No such column " + columnIndex);
        };
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cell edition (column " + columnIndex + ") = " + String.valueOf(value)));
        }
        Selectivity selectivity = this.selectivities.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                Equation eq = (Equation)value;
                selectivity.setEquation(null);
                selectivity.setEquation(eq);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Can't edit column " + columnIndex);
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return switch (column) {
            case 0 -> new JLabel(value.toString());
            case 1 -> {
                Equation equation = (Equation)value;
                yield new JButton(equation.getName() + "(" + equation.getCategory() + ")");
            }
            default -> throw new IndexOutOfBoundsException("No such column " + column);
        };
    }

    @Override
    public String getPropertyAtColumn(int column) {
        String result = null;
        if (column == 1) {
            result = "equation";
        }
        return result;
    }

    @Override
    public Object getBeanAtRow(int rowIndex) {
        Selectivity result = this.selectivities.get(rowIndex);
        return result;
    }
}

