/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.types.hibernate;

import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Result;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class MatrixDatabaseHelper {
    protected static Map<Class, Collection<String>> datas = new HashMap<Class, Collection<String>>();

    private static void addColumn(Class<?> keyClass, String column) {
        Collection columns = datas.computeIfAbsent(keyClass, v -> new ArrayList());
        columns.add(column);
    }

    public static List<TopiaEntity> checkUsedObjects(TopiaContext tx, TopiaEntity entity) {
        ArrayList<TopiaEntity> usedEntities = new ArrayList<TopiaEntity>();
        datas.forEach((clazz, columns) -> {
            String hql = "FROM " + clazz.getName() + " WHERE " + columns.stream().map(column -> column + "_semantics LIKE :entityId").collect(Collectors.joining(" OR "));
            List entities = tx.findAll(hql, new Object[]{"entityId", "%" + entity.getTopiaId() + "%"});
            usedEntities.addAll(entities);
        });
        return usedEntities;
    }

    static {
        MatrixDatabaseHelper.addColumn(Variable.class, "matrixValue");
        MatrixDatabaseHelper.addColumn(Result.class, "matrix");
        MatrixDatabaseHelper.addColumn(StrategyMonthInfo.class, "proportionMetier");
        MatrixDatabaseHelper.addColumn(Observation.class, "value");
        MatrixDatabaseHelper.addColumn(Population.class, "recruitmentDistribution");
        MatrixDatabaseHelper.addColumn(Population.class, "mappingZoneReproZoneRecru");
        MatrixDatabaseHelper.addColumn(Population.class, "capturability");
        MatrixDatabaseHelper.addColumn(PopulationSeasonInfo.class, "reproductionDistribution");
        MatrixDatabaseHelper.addColumn(PopulationSeasonInfo.class, "lengthChangeMatrix");
        MatrixDatabaseHelper.addColumn(PopulationSeasonInfo.class, "migrationMatrix");
        MatrixDatabaseHelper.addColumn(PopulationSeasonInfo.class, "emigrationMatrix");
        MatrixDatabaseHelper.addColumn(PopulationSeasonInfo.class, "immigrationMatrix");
    }
}

