/*
 * #%L
 * IsisFish
 * 
 * $Id: FilterParamModel.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.widget.filter;

import java.io.Serializable;

/**
 * This class represents the model for a parameter of a filter
 *
 * @see FilterAcceptor
 * @see FilterModel
 */
public class FilterParamModel<M, T> implements Serializable {
    private static final long serialVersionUID = -1116890939014115356L;

    public enum ResultState {
        NONE, OK, KO
    }

    public enum State {
        NONE, SKIP, USE
    }

    /** parameter identifier */
    protected String paramKey;

    /** val coming fro ui */
    protected T val;

    /** current state for this model */
    protected State state = State.NONE;

    /** current result state for this model */
    protected ResultState resultState = ResultState.NONE;

    /** number of hits for this param */
    protected int hits;

    /** param acceptor */
    protected transient FilterAcceptor<M, T> acceptor;

    public FilterParamModel(String paramKey, Class<T> type, ValueGetter<M, T> valueGetter) {
        this.paramKey = paramKey;
        this.acceptor = AcceptorFactory.createCompositeFilterAcceptor(type, valueGetter);
    }

    public void extractParam(Object... val) {

        if (!acceptor.canUse(val)) {
            state = State.SKIP;
            //resetResult();
        } else {
            state = State.USE;
            //resultState = ResultState.NONE;
            if (val.length == 1) {
                this.val = acceptor.extract(val[0]);
            } else {
                this.val = acceptor.extract(val);
            }
        }
        //hits = 0;
        //resultState= ResultState.NONE;
    }

    public boolean accept(M item) {
        boolean newValue = acceptor.acceptParam(item, val);
        if (newValue) {            
            hits++;
        }
        return newValue;
    }

    public void reset() {
        state = State.NONE;
        resetResult();
    }

    public void resetResult() {
        resultState = ResultState.NONE;
        hits = 0;
        val = null;
    }

    public boolean canUse(String... val) {
        return acceptor.canUse(val);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (key ").append(paramKey).append(')');
        sb.append(" (val ").append(val).append(')');
        sb.append(" (state ").append(state).append(')');
        sb.append(" (resultState ").append(resultState).append(')');
        sb.append(" (hits ").append(hits).append(')');
        return sb.toString();
    }
}
