/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2009 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.script.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JDialog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ZipUtil;

import fr.ifremer.isisfish.ui.script.FileSelectionTableModel;
import fr.ifremer.isisfish.ui.util.IsisActionWithBackup;

/**
 * Action for import zip content into isis script directory.
 * 
 * @author chatellier
 * @version $Revision$
 * 
 * Last update : $Date$
 * By : $Author$
 * 
 * @deprecated C'est pas evident de faire des Actions swing avec jaxx
 */
public class ImportAction extends IsisActionWithBackup {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2459027106690418279L;

    /** log. */
    private static Log log = LogFactory.getLog(ImportAction.class);

    /** Model to contains new files to add from import. */
    protected FileSelectionTableModel model;

    /** Model to contains files conflicted from import. */
    protected FileSelectionTableModel modelWithBackup;

    /** Location of archive to import. */
    protected File source;

    /** List of relative path to import (is init in {@link #prepare()} method). */
    private List<String> toImport;

    /**
     * Import action constructor.
     * 
     * @param dialog dialog ???
     * @param source zip file
     * @param root destination directory
     * @param modelNewItems added files model (for selection)
     * @param modelItems conflict files model (for selection)
     */
    public ImportAction(JDialog dialog, File source, File root,
            FileSelectionTableModel modelNewItems,
            FileSelectionTableModel modelItems) {
        super(dialog, root);
        this.source = source;
        this.model = modelNewItems;
        this.modelWithBackup = modelItems;
    }

    @Override
    protected boolean prepare() {
        if (source == null || (model == null && modelWithBackup == null)
                || "".equals(source.getAbsolutePath())) {
            return false;
        }

        toImport = new ArrayList<String>();
        if (model != null) {
            // add new files            
            toImport.addAll(model.getSelectedFiles());
        }

        if (modelWithBackup != null) {
            // add selected files (force overwrite)
            toImport.addAll(modelWithBackup.getSelectedFiles());
        }

        return !toImport.isEmpty();
    }

    @Override
    protected void perform(ActionEvent e) {

        // do backup stuff
        super.perform(e);

        // unflate files to destination (root)
        try {
            if (log.isInfoEnabled()) {
                for (String newFile : toImport) {
                    log.info("unzip " + newFile);
                }
            }
            ZipUtil.uncompress(source, root, toImport, null, null);

        } catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        if (log.isInfoEnabled()) {
            log.info("unzip " + toImport.size() + " entry(ies) from '" + source
                    + "'");
        }
        toImport.clear();
    }

    @Override
    protected List<String> getFilesToBackup() {
        List<String> toBackup = new ArrayList<String>();
        if (modelWithBackup != null) {
            toBackup.addAll(modelWithBackup.getSelectedFiles());
        }
        return toBackup;
    }
}
