/*
 * #%L
 * IsisFish
 * 
 * $Id: ObjectiveComboRenderer.java 3924 2014-04-03 13:43:32Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.1.0/src/main/java/fr/ifremer/isisfish/ui/models/optimization/ObjectiveComboRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.optimization;

import static org.nuiton.i18n.I18n.t;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.ui.util.TooltipHelper;

/**
 * Renderer pour la combo des script d'optimisation.
 *
 * @author chatellier
 * @version $Revision: 3924 $
 * 
 * Last update : $Date: 2014-04-03 15:43:32 +0200 (Thu, 03 Apr 2014) $
 * By : $Author: echatellier $
 */
public class ObjectiveComboRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Objective cache. */
    protected Map<String, Objective> objectiveCache;

    /**
     * Empty constructor.
     */
    public ObjectiveComboRenderer() {
        objectiveCache = new HashMap<String, Objective>();
    }

    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel) super.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);

        String objectiveName = (String) value;
        c.setText(objectiveName);

        // c'est tres couteux d'avoir une instance
        // on les met en cache
        try {
            Objective objective = objectiveCache.get(objectiveName);
            if (objective == null) {
                ObjectiveStorage storage = ObjectiveStorage
                        .getObjective(objectiveName);
                objective = storage.getNewInstance();
                objectiveCache.put(objectiveName, objective);
            }

            c.setToolTipText(objective.getDescription());
        } catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(t("isisfish.error.compile.fileerror", objectiveName));
            c.setToolTipText(errorTooltip);
        }

        return c;
    }
}
