package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.variable.EntityVariableUI;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class ZoneUI extends InputContentUI<fr.ifremer.isisfish.entities.Zone> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VARIABLES_UI_ACTIVE = "variablesUI.active";
    public static final String BINDING_VARIABLES_UI_BEAN = "variablesUI.bean";
    public static final String BINDING_VARIABLES_UI_SENSITIVITY = "variablesUI.sensitivity";
    public static final String BINDING_ZONE_BASICS_UI_ACTIVE = "zoneBasicsUI.active";
    public static final String BINDING_ZONE_BASICS_UI_BEAN = "zoneBasicsUI.bean";
    public static final String BINDING_ZONE_BASICS_UI_SENSITIVITY = "zoneBasicsUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz08TQRR+rbSlFAUhIigkoHgg6lZjYkxqFEWJJfVHRAyhF2e7UzpkOzvOzJatB+Of4J+gdy8m3jwZD549eDH+C8Z48Gp8s/0NK21CDzvb977vm/fefu/dT0goCQs7JAgs6XPNqtRau7W5+dDeoSV9h6qSZEJ7Ehq/WBziRcg47bjScLZYMPRsk55d8arC45R3sXMFGFG67lJVoVRrmOtllJTKrrfTuUD4sqXaLipK9c3vX/HXzqu3cYBAYHXD2Mp8P1ank6ECxJmjYQJvqpGsS/g2liEZ38Z6j5rYikuUekCq9Dm8hFQBkoJIFNNwZvCWQ42QHwgN44t5Lny94nGN8I38JZxfWVqsLGmV4qmYKjNVsXxmMQO0tlB3Iy9EKJHUMGRTwjUsRJFQkWlGVUjqpnhOHds0HQWW2sUGrbVHhFO3g0m9QMoTYms42QPDkE0dAzbAsTZ+1OBvE8VKaiOvYalvDy2s4U+0ZTI1Ihmx8csblasHqrSg1l3TZv1p8+9eyfQi1pznZQ9He6rHDI2Wmlmxn3DZBOYwIeF0DxH9aXX82TFQrAgJ6WNYw3Rxv6UfY6ph5uk9ZjaCYfbv1OS3jz8+rLYcnMS7T0RCuxYQnSWkJ6g031rDWMO+vmZu9j4RuSKkFXVxe8PtnI0obL2ZxuLwvuOGbhm6dY+oCkokUt8/fZ569vUIxFdhxPWIs0oMPg9pXZE4Bc91AnFzOaxodHcYn+OmNg1JxLEazujYdYdoMm8z7uDQbwQ4hNmIIbQrsdNf/kyuv19uDSKGhc38F94ZRmILkoy7jNNwmZt7Grm8GaGo73idfYza0Jg5p0TTHefC51JUp+EemuyFwDfHxbBo85YdWCOjKFe4sTW086GkTPj8AQozAylcObTCtT4K/wDTk4D/bwYAAA==";
    private static final Log log = LogFactory.getLog(ZoneUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Zone bean;
    protected EntityVariableUI variablesUI;
    protected ZoneBasicsUI zoneBasicsUI;
    protected JTabbedPane zoneTab;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ZoneUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        setButtonTitle(t("isisfish.input.continuePorts"));
        setNextPath(n("isisfish.input.tree.ports"));
    
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        installChangeListener(zoneTab);
    }
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        zoneBasicsUI.setLayer(active);
        variablesUI.setLayer(active);
    }
    
    @Override
    public void resetChangeModel() {
        zoneBasicsUI.resetChangeModel();
        variablesUI.resetChangeModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ZoneUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ZoneUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ZoneUI() {
        $initialize();
    }

    public ZoneUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ZoneUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ZoneUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ZoneUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ZoneUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Zone getBean() {
        return bean;
    }

    public EntityVariableUI getVariablesUI() {
        return variablesUI;
    }

    public ZoneBasicsUI getZoneBasicsUI() {
        return zoneBasicsUI;
    }

    public JTabbedPane getZoneTab() {
        return zoneTab;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Zone bean) {
        Zone oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(zoneTab, BorderLayout.CENTER);
    }

    protected void addChildrenToZoneTab() {
        if (!allComponentsCreated) {
            return;
        }
        zoneTab.add(zoneBasicsUI);
        zoneTab.add(variablesUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(zoneTab, 0));
        zoneTab.setTitleAt(0, t("isisfish.zone.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(zoneTab, 1));
        zoneTab.setTitleAt(1, t("isisfish.variables.tabtitle"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createVariablesUI() {
        $objectMap.put("variablesUI", variablesUI = new EntityVariableUI(this));
        
        variablesUI.setName("variablesUI");
    }

    protected void createZoneBasicsUI() {
        $objectMap.put("zoneBasicsUI", zoneBasicsUI = new ZoneBasicsUI(this));
        
        zoneBasicsUI.setName("zoneBasicsUI");
    }

    protected void createZoneTab() {
        $objectMap.put("zoneTab", zoneTab = new JTabbedPane());
        
        zoneTab.setName("zoneTab");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToZoneTab();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createZoneTab();
        createZoneBasicsUI();
        createVariablesUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.zone.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("isisfish.variables.tabtitle"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_BASICS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                zoneBasicsUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_BASICS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                zoneBasicsUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_BASICS_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                zoneBasicsUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLES_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                variablesUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLES_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                variablesUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLES_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                variablesUI.setSensitivity(isSensitivity());
            }
        });
    }

}