package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.ui.NavigationUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeSelectionModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class InputUI extends NavigationUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_REGION_LOADED = "regionLoaded";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_NEW_REGION_ENABLED = "buttonNewRegion.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JMENU_ITEM3_ENABLED = "$JMenuItem3.enabled";
    private static final String BINDING_$JMENU_ITEM4_ENABLED = "$JMenuItem4.enabled";
    private static final String BINDING_$JMENU_ITEM5_ENABLED = "$JMenuItem5.enabled";
    private static final String BINDING_$JMENU_ITEM6_ENABLED = "$JMenuItem6.enabled";
    private static final String BINDING_$JMENU_ITEM7_ENABLED = "$JMenuItem7.enabled";
    private static final String BINDING_$JMENU_ITEM8_ENABLED = "$JMenuItem8.enabled";
    private static final String BINDING_$JMENU_ITEM9_ENABLED = "$JMenuItem9.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Xz28bRRSemPxomh+lDklbCBBCELSITZPSlJKotEmJ4sgJJU5LwBJi7J3YE2Z3ltnZeNND4U/gT4A7FyRunBCHHhESXFAv/QMQ4sAV8WZs73rj9XqlxYe1Pe9933zv7Zv3dr/7Ew25Ar1yhH3fEJ4tqUWM7TsHBx9UjkhV3iVuVVBHcoGan4EcypXRmBmsuxK9Wi4q+GILvrjBLYfbxO5ArxbRWVeeMOLWCZESvRhFVF13sRSYV33HE23WQFQc6zd//5X72vzq2xxCvgPq5iGUuX6oMJLBIspRU6I87HSMFxm2ayBDULsGeifU2gbDrruLLfIFeoRGimjYwQLIJJpPH7Lm0HjfkWhyYRcf0xqWlNv3C1clWjgUBj0UxCLw7VL3kLp1w6MGtR1PGgV1vV9wHM0wLNFIHdsmI0Kiy/2BW03fED0uSA02LnJsEgj8vIrRUHEb65wzgu3QddAitifRc8rFN9wGZMXY3oG1dSyUy2goaUGvX23xRZyVSz7wHGt6FiSxwHu6y1sZlOt0HGJJLT3f07ycbL6WbH47xjy+sF0icMMx3E2QOxORG1h6Ul6PoWylSodyoWduVgLkG3HmGzHmTq2a/bWe8Hdi4C1dy8m6bgbI5cjGDqPyHrZJd5LalmjBnFnYVosM/PMRf72qnFY6lO3jClPUFyMHu4nQNuV5MwBMHlLCzF3S2NOlflrSPvHlpvJQ7msB6lzFk5LbHbCpCGxdm6OYvN5pwxOqJbRh0aKGvlDh69yPAkelICSIdTWqfwISWhWcsVZGL0QzGpiU+1aAelmdfiJOmjL2gb9EGDRw+LPDTcIkutLJowQYd8kh9pjsdg6bwPku2tOHXK0p5+0AM1XFwmT4hHvyHvTSKnUwa6XTwA1pbIC5qM3hPnndtFRYASRIzUpX3SwFtgdhu7Kh/56upyKuNHN8EOY+2KmTRKAXItUFA8kIB1I4MQbKaEh4sAzlWO6eYXtgak6vi6emlyLU1n9npn7/8ckPm+2RdQX2no517Zi4MEocwR3o+lRtfa45rzxJ2eIOdlbLaNTVN1CP49kYYaWWGcTBfs22r+DGFnbrQDE08sdPP8989uszKLeJzjIYD5tY+RegVusCssCZ6Tvv3daKxhtn4Pqs0gZ5l3CgIO9r1GbUJnNYwgCFw0Ru+ZCG2Zg0BFoqo4//mSp9f7udigGQdqmne5iOoU/QcHM3Pb9bozl2Xo85LvFMHo7guKE8oL5nnFY1mvpa745VLR+py+e+HmtMS1a/bG27lJlhNjPDS30ZoKMSW3VNGP+TayaWeK5CbROOy614yrnMotIxPFKXL+MZ5jNrSMeQpOH1zBqyM1zOHMWbmTWkY0jS8FZmDekYkjQsZdaQneFa5iiuZ9bQnwHGjUmPqUlEkVf1a0sC3Y0UdHkY1Pvcq9bf9x14P2k/wWVgHOOCwiPY/yFuuPngkpDzd9MIsqhNLc8q0YckE1W/AtjIXAD9GSQastRTYYKMzVQyfklgKKSQMWi3BnuPUNJwTLidT7oJgnZThfQ0geHDNIUiOJcP4O09+RCkoRoVvLFFaK0uMxJNRlKUdNvTsI0HbHu8kUlZvxL6KBXDb5kZkjR8nCIjU3VoVw/hXRGzO4zWbAtaV0JiypmPeDqGpLA+BYb/AFCJ3zMqFAAA";
    private static final Log log = LogFactory.getLog(InputUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton buttonNewRegion;
    protected CardLayout cardlayoutPrincipal;
    protected JComboBox<String> fieldCurrentRegion;
    protected JTextField fieldNewRegion;
    protected JTree fisheryRegionTree;
    protected DefaultTreeSelectionModel fisheryRegionTreeSelectionModel;
    protected InputHandler handler;
    protected JPanel inputPane;
    protected JPanel inputPanePrincipal;
    protected JMenuBar menu;
    protected JLabel none;
    protected Boolean regionLoaded;
    protected JPanel treePanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenu $JMenu0;
    private JMenu $JMenu1;
    private JMenu $JMenu2;
    private JMenuItem $JMenuItem0;
    private JMenuItem $JMenuItem1;
    private JMenuItem $JMenuItem2;
    private JMenuItem $JMenuItem3;
    private JMenuItem $JMenuItem4;
    private JMenuItem $JMenuItem5;
    private JMenuItem $JMenuItem6;
    private JMenuItem $JMenuItem7;
    private JMenuItem $JMenuItem8;
    private JMenuItem $JMenuItem9;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSplitPane $JSplitPane0;
    private InputUI $NavigationUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public InputUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public InputUI() {
        $initialize();
    }

    public InputUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public InputUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public InputUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public InputUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().importRegion(this);
    }

    public void doActionPerformed__on__$JMenuItem1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().importRegionAndRename(this);
    }

    public void doActionPerformed__on__$JMenuItem2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().importRegionFromSimulation(this);
    }

    public void doActionPerformed__on__$JMenuItem3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().exportRegion(this);
    }

    public void doActionPerformed__on__$JMenuItem4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().copyRegion(this);
    }

    public void doActionPerformed__on__$JMenuItem5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeRegion(this, false);
    }

    public void doActionPerformed__on__$JMenuItem6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().commitRegionInCVS(this);
    }

    public void doActionPerformed__on__$JMenuItem7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().commitRegionInCVS(this);
    }

    public void doActionPerformed__on__$JMenuItem8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeRegion(this, true);
    }

    public void doActionPerformed__on__$JMenuItem9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().exportRegionSensitivityFactors(this);
    }

    public void doActionPerformed__on__buttonNewRegion(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createNewRegion(this);
    }

    public void doItemStateChanged__on__fieldCurrentRegion(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().regionChange(this, event);
    }

    public void doValueChanged__on__fisheryRegionTree(TreeSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().nodeSelectionChanged(this, event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getButtonNewRegion() {
        return buttonNewRegion;
    }

    public CardLayout getCardlayoutPrincipal() {
        return cardlayoutPrincipal;
    }

    public JComboBox<String> getFieldCurrentRegion() {
        return fieldCurrentRegion;
    }

    public JTextField getFieldNewRegion() {
        return fieldNewRegion;
    }

    public JTree getFisheryRegionTree() {
        return fisheryRegionTree;
    }

    public DefaultTreeSelectionModel getFisheryRegionTreeSelectionModel() {
        return fisheryRegionTreeSelectionModel;
    }

    public InputHandler getHandler() {
        return handler;
    }

    public JPanel getInputPane() {
        return inputPane;
    }

    public JPanel getInputPanePrincipal() {
        return inputPanePrincipal;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JLabel getNone() {
        return none;
    }

    public Boolean getRegionLoaded() {
        return regionLoaded;
    }

    public JPanel getTreePanel() {
        return treePanel;
    }

    public Boolean isRegionLoaded() {
        return regionLoaded !=null && regionLoaded;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setRegionLoaded(Boolean regionLoaded) {
        Boolean oldValue = this.regionLoaded;
        this.regionLoaded = regionLoaded;
        firePropertyChange(PROPERTY_REGION_LOADED, oldValue, regionLoaded);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenu get$JMenu1() {
        return $JMenu1;
    }

    protected JMenu get$JMenu2() {
        return $JMenu2;
    }

    protected JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    protected JMenuItem get$JMenuItem1() {
        return $JMenuItem1;
    }

    protected JMenuItem get$JMenuItem2() {
        return $JMenuItem2;
    }

    protected JMenuItem get$JMenuItem3() {
        return $JMenuItem3;
    }

    protected JMenuItem get$JMenuItem4() {
        return $JMenuItem4;
    }

    protected JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected JMenuItem get$JMenuItem6() {
        return $JMenuItem6;
    }

    protected JMenuItem get$JMenuItem7() {
        return $JMenuItem7;
    }

    protected JMenuItem get$JMenuItem8() {
        return $JMenuItem8;
    }

    protected JMenuItem get$JMenuItem9() {
        return $JMenuItem9;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToInputPanePrincipal() {
        if (!allComponentsCreated) {
            return;
        }
        inputPanePrincipal.add($JPanel1, "none");
        inputPanePrincipal.add(inputPane, "normale");
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add($JMenu0);
        menu.add($JMenu1);
        menu.add($JMenu2);
    }

    protected void addChildrenToTreePanel() {
        if (!allComponentsCreated) {
            return;
        }
        treePanel.add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void createButtonNewRegion() {
        $objectMap.put("buttonNewRegion", buttonNewRegion = new JButton());
        
        buttonNewRegion.setName("buttonNewRegion");
        buttonNewRegion.setText(t("isisfish.input.newRegion"));
        buttonNewRegion.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonNewRegion"));
    }

    protected void createCardlayoutPrincipal() {
        $objectMap.put("cardlayoutPrincipal", cardlayoutPrincipal = new CardLayout());
    }

    protected void createFieldCurrentRegion() {
        $objectMap.put("fieldCurrentRegion", fieldCurrentRegion = new JComboBox<String>());
        
        fieldCurrentRegion.setName("fieldCurrentRegion");
        fieldCurrentRegion.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldCurrentRegion"));
    }

    protected void createFieldNewRegion() {
        $objectMap.put("fieldNewRegion", fieldNewRegion = new JTextField());
        
        fieldNewRegion.setName("fieldNewRegion");
        fieldNewRegion.setColumns(15);
    }

    protected void createFisheryRegionTree() {
        $objectMap.put("fisheryRegionTree", fisheryRegionTree = new JTree());
        
        fisheryRegionTree.setName("fisheryRegionTree");
        fisheryRegionTree.setRootVisible(true);
        fisheryRegionTree.setRowHeight(0);
        fisheryRegionTree.setSelectionRow(0);
        fisheryRegionTree.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__fisheryRegionTree"));
    }

    protected void createFisheryRegionTreeSelectionModel() {
        $objectMap.put("fisheryRegionTreeSelectionModel", fisheryRegionTreeSelectionModel = new DefaultTreeSelectionModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new InputHandler());
    }

    protected void createInputPane() {
        $objectMap.put("inputPane", inputPane = new JPanel());
        
        inputPane.setName("inputPane");
        inputPane.setLayout(new BorderLayout());
    }

    protected void createInputPanePrincipal() {
        $objectMap.put("inputPanePrincipal", inputPanePrincipal = new JPanel());
        
        inputPanePrincipal.setName("inputPanePrincipal");
        inputPanePrincipal.setLayout(getCardlayoutPrincipal());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createNone() {
        $objectMap.put("none", none = new JLabel());
        
        none.setName("none");
        none.setHorizontalAlignment(0);
        none.setText(t("isisfish.input.selectRegion"));
    }

    protected void createRegionLoaded() {
        $objectMap.put("regionLoaded", regionLoaded = false);
    }

    protected void createTreePanel() {
        $objectMap.put("treePanel", treePanel = new JPanel());
        
        treePanel.setName("treePanel");
        treePanel.setLayout(new BorderLayout());
        treePanel.setName("treePanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $NavigationUI0
        add(menu, BorderLayout.NORTH);
        add($JSplitPane0, BorderLayout.CENTER);
        addChildrenToMenu();
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenuItem0);
        $JMenu0.add($JMenuItem1);
        $JMenu0.add($JMenuItem2);
        $JMenu0.add($JMenuItem3);
        $JMenu0.add($JMenuItem4);
        $JMenu0.add($JSeparator0);
        $JMenu0.add($JMenuItem5);
        // inline complete setup of $JMenu1
        $JMenu1.add($JMenuItem6);
        $JMenu1.add($JMenuItem7);
        $JMenu1.add($JSeparator1);
        $JMenu1.add($JMenuItem8);
        // inline complete setup of $JMenu2
        $JMenu2.add($JMenuItem9);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add(inputPanePrincipal, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add($Table0, BorderLayout.NORTH);
        $JPanel0.add(treePanel);
        // inline complete setup of $Table0
        $Table0.add(fieldNewRegion, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(buttonNewRegion, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldCurrentRegion, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTreePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fisheryRegionTree);
        addChildrenToInputPanePrincipal();
        // inline complete setup of $JPanel1
        $JPanel1.add(none, BorderLayout.CENTER);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        $JPanel0.setMinimumSize(new java.awt.Dimension(0,0));
        fieldCurrentRegion.setModel(new fr.ifremer.isisfish.ui.models.common.GenericComboModel<String>(fr.ifremer.isisfish.datastore.RegionStorage.getRegionNames()));
        fisheryRegionTreeSelectionModel.setSelectionMode(javax.swing.tree.TreeSelectionModel.SINGLE_TREE_SELECTION);
        fisheryRegionTree.setModel(new javax.swing.tree.DefaultTreeModel(null));
        fisheryRegionTree.setSelectionModel(fisheryRegionTreeSelectionModel);
        inputPanePrincipal.setMinimumSize(new java.awt.Dimension(0,0));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$NavigationUI0", $NavigationUI0);
        createHandler();
        createRegionLoaded();
        createMenu();
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("isisfish.common.region"));
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setText(t("isisfish.input.menu.importRegion"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        // inline creation of $JMenuItem1
        $objectMap.put("$JMenuItem1", $JMenuItem1 = new JMenuItem());
        
        $JMenuItem1.setName("$JMenuItem1");
        $JMenuItem1.setText(t("isisfish.input.menu.importRenameRegion"));
        $JMenuItem1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem1"));
        // inline creation of $JMenuItem2
        $objectMap.put("$JMenuItem2", $JMenuItem2 = new JMenuItem());
        
        $JMenuItem2.setName("$JMenuItem2");
        $JMenuItem2.setText(t("isisfish.input.menu.importRegionSimulation"));
        $JMenuItem2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem2"));
        // inline creation of $JMenuItem3
        $objectMap.put("$JMenuItem3", $JMenuItem3 = new JMenuItem());
        
        $JMenuItem3.setName("$JMenuItem3");
        $JMenuItem3.setText(t("isisfish.input.menu.exportRegion"));
        $JMenuItem3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem3"));
        // inline creation of $JMenuItem4
        $objectMap.put("$JMenuItem4", $JMenuItem4 = new JMenuItem());
        
        $JMenuItem4.setName("$JMenuItem4");
        $JMenuItem4.setText(t("isisfish.input.menu.copyRegion"));
        $JMenuItem4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem4"));
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JMenuItem5
        $objectMap.put("$JMenuItem5", $JMenuItem5 = new JMenuItem());
        
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setText(t("isisfish.input.menu.removeLocaly"));
        $JMenuItem5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem5"));
        // inline creation of $JMenu1
        $objectMap.put("$JMenu1", $JMenu1 = new JMenu());
        
        $JMenu1.setName("$JMenu1");
        $JMenu1.setText(t("isisfish.input.menu.server"));
        // inline creation of $JMenuItem6
        $objectMap.put("$JMenuItem6", $JMenuItem6 = new JMenuItem());
        
        $JMenuItem6.setName("$JMenuItem6");
        $JMenuItem6.setText(t("isisfish.input.menu.addRegion"));
        $JMenuItem6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem6"));
        // inline creation of $JMenuItem7
        $objectMap.put("$JMenuItem7", $JMenuItem7 = new JMenuItem());
        
        $JMenuItem7.setName("$JMenuItem7");
        $JMenuItem7.setText(t("isisfish.input.menu.commit"));
        $JMenuItem7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem7"));
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        // inline creation of $JMenuItem8
        $objectMap.put("$JMenuItem8", $JMenuItem8 = new JMenuItem());
        
        $JMenuItem8.setName("$JMenuItem8");
        $JMenuItem8.setText(t("isisfish.input.menu.removeLocalyRemotely"));
        $JMenuItem8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem8"));
        // inline creation of $JMenu2
        $objectMap.put("$JMenu2", $JMenu2 = new JMenu());
        
        $JMenu2.setName("$JMenu2");
        $JMenu2.setText(t("isisfish.input.menu.sensitivity"));
        // inline creation of $JMenuItem9
        $objectMap.put("$JMenuItem9", $JMenuItem9 = new JMenuItem());
        
        $JMenuItem9.setName("$JMenuItem9");
        $JMenuItem9.setText(t("isisfish.input.menu.sensitivity.export"));
        $JMenuItem9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem9"));
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFieldNewRegion();
        createButtonNewRegion();
        createFieldCurrentRegion();
        createTreePanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFisheryRegionTreeSelectionModel();
        createFisheryRegionTree();
        createCardlayoutPrincipal();
        createInputPanePrincipal();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createNone();
        createInputPane();
        // inline creation of $NavigationUI0
        setName("$NavigationUI0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM3_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem3.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM4_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem4.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM5_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem5.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM6_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem6.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM7_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem7.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM8_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem8.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM9_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem9.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUTTON_NEW_REGION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getFieldNewRegion() != null) {
                    $bindingSources.put("getFieldNewRegion().getDocument()", getFieldNewRegion().getDocument());
                    getFieldNewRegion().getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    getFieldNewRegion().addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.input.InputUI.this, BINDING_BUTTON_NEW_REGION_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFieldNewRegion() != null && getFieldNewRegion().getText() != null) {
                    buttonNewRegion.setEnabled(getFieldNewRegion().getText().length() > 0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getFieldNewRegion() != null) {
                    Document $target = (Document) $bindingSources.remove("getFieldNewRegion().getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    getFieldNewRegion().removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.input.InputUI.this, BINDING_BUTTON_NEW_REGION_ENABLED));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}