package fr.ifremer.isisfish.ui;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public abstract class SimulationUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_REGION_STORAGE = "regionStorage";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRAdm/gzJAGbfIkgmRBRADqHOhEEgiJsOYBikCLcsOdb2xvdx7K7l1waxE/gJ0BPg0RHhSioKWgQfwEhClrE7Nm+s/GhIOHi7jzz5u2b2Tevv0FGCrh4QILAEL6rmEON+q39/fvmAW2rO1S2BePKE9D/pdKQbsG0FcWlgkuthi6vDsqr257DPZe6I9UbDShKdWxT2aNUKbgwXtGWstqM0hsB98WQNRKVxPryx/f0C+v5qzRAwFFdDlupnFQVdzLVgDSzFJTwpENStYnbRRmCuV3UO6Nj2zaR8h5x6FN4BrkGZDkRSKZg9d9bDjnC+oAryK/VHxCX2us4t44wWEdQh+JbMtlhsmf4zGgyx7eJYp77qMZ5WJpVMCNoF0NNpCZdquBqUrVFFJGIoMbeKDpmKa7Vd6nr3yYCBZzTLQaGPMKOjWFcAwsRPtfHI/jsBFhD5iJk1mFNcojC5ieANUUdjSpF4LzDajgxofT/xfHcrOlZxw+JaVJLT0rB4hhhnBkoFXB+7MrRTEZspvi2Uy3ICB/DCpZak/7bw1TfeUt/OE8ThtlfC+XP776+3RnabQrPnk+EjmwL2oALj1OhmD56ru81XzG7ukv4RgsKktq4auEqrSQIaw7SKA7PC6/B0OXGXSJ7SJHJfXn/YeHJp1OQ3oGi7RFrh2h8DQqqJ3AKnm0F/OZWqOj0UR6fZ7Q2vDKbHHs+unl2UxunYjLXwhnfCHAIKwlDiJSYhY8/y803W8NBpFDY8l/h8TAyjyHLXJu5NNy8wVIlbto0l9S3vHh5ktYppd9FPrD3avi8nNTplKIB9lna7J9eIQrX3PQVxV510ZWwCf11LeQsn8ipw+v6cT2ZYeG/GZaR4Tf8BidbnwUAAA==";
    private static final Log log = LogFactory.getLog(SimulationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTabbedPane bodyTabbedPane;
    protected JMenuItem miImport;
    protected JMenuItem miSave;
    protected RegionStorage regionStorage;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenu $JMenu0;
    private JMenuBar $JMenuBar0;
    private SimulationUI $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            addPropertyChangeListener(PROPERTY_REGION_STORAGE, new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    regionStorageChanged();
                }
            });
        }
    
        /**
         * Refresh all simulation launch UI.
         */
        protected abstract void regionStorageChanged();
    
        /**
         * Refresh all simulation launch UI.
         */
        protected abstract void refresh();
    
        /**
         * Set selected tab to parameters tab.
         */
        public abstract void selectParametersTab();
    
        /**
         * Change prescript tab enabled property.
         */
        public abstract void setEnabledPrescriptTab(boolean selected);
        
        /**
         * Change simulation plan tab enabled property.
         */
        public abstract void setEnabledSimulationPlanTab(boolean selected);
    
        /**
         * Change optimization tab enabled property.
         */
        public abstract void setEnabledOptimizationTab(boolean selected);
    
        /**
         * Open user dialog to selected a parameter file.
         * Reload it, and call {@link #refresh()}.
         */
        protected void importSimulation() {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
    
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = fc.getSelectedFile();
                //This is where a real application would open the file.
                getContextValue(SimulAction.class).importSimulation(file);
                refresh();
            }
        }
    
        /**
         * Save current parameter in user selected parameter output file.
         */
        public void saveSimulation() {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
    
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = fc.getSelectedFile();
                //This is where a real application would open the file.
                getContextValue(SimulAction.class).saveSimulation(file);
            }
        }
        
        /**
         * Rafraichit l'arbre des facteurs.
         */
        public void refreshFactorTree() {
        
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimulationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SimulationUI() {
        $initialize();
    }

    public SimulationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SimulationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimulationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SimulationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimulationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__miImport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        importSimulation();
    }

    public void doActionPerformed__on__miSave(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveSimulation();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTabbedPane getBodyTabbedPane() {
        return bodyTabbedPane;
    }

    public JMenuItem getMiImport() {
        return miImport;
    }

    public JMenuItem getMiSave() {
        return miSave;
    }

    public RegionStorage getRegionStorage() {
        return regionStorage;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setRegionStorage(RegionStorage regionStorage) {
        RegionStorage oldValue = this.regionStorage;
        this.regionStorage = regionStorage;
        firePropertyChange(PROPERTY_REGION_STORAGE, oldValue, regionStorage);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBodyTabbedPane() {
        $objectMap.put("bodyTabbedPane", bodyTabbedPane = new JTabbedPane());
        
        bodyTabbedPane.setName("bodyTabbedPane");
    }

    protected void createMiImport() {
        $objectMap.put("miImport", miImport = new JMenuItem());
        
        miImport.setName("miImport");
        miImport.setText(t("isisfish.simulation.menu.import"));
        miImport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miImport"));
    }

    protected void createMiSave() {
        $objectMap.put("miSave", miSave = new JMenuItem());
        
        miSave.setName("miSave");
        miSave.setText(t("isisfish.simulation.menu.save"));
        miSave.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miSave"));
    }

    protected void createRegionStorage() {
        $objectMap.put("regionStorage", regionStorage = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JMenuBar0, BorderLayout.NORTH);
        add(SwingUtil.boxComponentWithJxLayer(bodyTabbedPane), BorderLayout.CENTER);
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add($JMenu0);
        // inline complete setup of $JMenu0
        $JMenu0.add(miSave);
        $JMenu0.add(miImport);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createRegionStorage();
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("isisfish.simulation.menu.simulation"));
        createMiSave();
        createMiImport();
        createBodyTabbedPane();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}