/*
 * #%L
 * IsisFish
 * 
 * $Id: LogMail.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, Code Lutin, Benjamin Poussin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.logging.console;

import static org.nuiton.i18n.I18n.t;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;
import org.nuiton.widget.StatusBar;

import fr.ifremer.isisfish.ui.logging.console.LogMailUI;

/**
 * This is the dialog to send mail from LogConsole
 *
 * @author chemit
 */
public class LogMail extends LogMailUI {

    /** serialVersionUID */
    private static final long serialVersionUID = 1L;

    static private final Log log = LogFactory.getLog(LogMail.class);

    /** the simulation directory */
    protected File simulationFile;

    /** the log file */
    protected File logFile;

    /** server to use for mail send */
    protected String smtpServer;

    /** default destinataire for mail send */
    protected String to;

    /** default from from mail send */
    protected String from;

    /** the console status bar where to notify user events */
    protected StatusBar statusBar;

    public LogMail(final StatusBar statusBar, String from, File logFile, File simulationFile, final String smtpServer) {
        setTitle(t("isisfish.log.mail.send.title", simulationFile.getName()));
        this.from = from;
        this.logFile = logFile;
        this.simulationFile = simulationFile;
        this.smtpServer = smtpServer;
        this.statusBar = statusBar;

        sendMail.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    sendMail(mailTo.getText(), content.getText(), sendAll.isSelected());
                    statusBar.setStatus(t("isisfish.log.mail.send" , to));
                } catch (Exception eee) {
                    statusBar.setStatus(t("isisfish.log.mail.failed", smtpServer));
                } finally {
                    dispose();
                }
            }
        });
    }

    public void setTo(String to) {
        this.to = to;
    }

    /**
     * Send an email using the given informations (stmpServer, toAddress,
     * fromAddress, subject and body).
     *
     * @param to       adr to send the mail
     * @param text     message text
     * @param selected if <code>true</code> send all simulation zip,
     *                 or just the file
     * @throws java.io.IOException           if any problem while creatingthe zip
     * @throws javax.mail.MessagingException if any problem while creating
     *                                       the message or while the send
     */
    public void sendMail(String to, String text, boolean selected) throws IOException, MessagingException {

        Properties props = System.getProperties();

        // -- Attaching to default Session, or we could start a new one --
        props.put("mail.smtp.host", smtpServer);
        Session session = Session.getDefaultInstance(props, null);

        // -- Create a new message --
        Message msg = new MimeMessage(session);

        // -- Set the FROM and TO fields --
        msg.setFrom(new InternetAddress(from));

        msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to, false));


        MimeMultipart bodyMime = new MimeMultipart("mixed");


        BodyPart attPart = new MimeBodyPart();

        // -- Set the subject and body text --
        String subject = t("isisfish.log.simulation.name",simulationFile.getName());
        msg.setSubject(subject);

        final File zipFile;
        File tmpDirectory = null;

        if (!selected) {
            // just send the log file

            zipFile = logFile;

            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

            // Zippage du zipFile pour le mettre en piece jointe
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            BufferedWriter zipWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            zipOutputStream.putNextEntry(new ZipEntry(zipFile.getName()));
            String content = FileUtils.readFileToString(zipFile);

            zipWriter.write(content);
            zipWriter.flush();
            zipOutputStream.closeEntry();
            zipWriter.close();


            attPart.setDataHandler(new DataHandler(new DataSource() {

                public String getContentType() {
                    return "application/zip";
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }

                public String getName() {
                    return simulationFile.getName() + ".zip";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            }));

        } else {
            // send the simulation zipped
            File root = simulationFile;
            tmpDirectory = FileUtil.createTempDirectory("isis-simultation-", "-sendLog");

            zipFile = new File(tmpDirectory, root.getName() + ".zip");

            ZipUtil.compress(zipFile, root, null);

            attPart.setDataHandler(new DataHandler(new DataSource() {

                public String getContentType() {
                    return "application/zip";
                }

                public InputStream getInputStream() throws IOException {
                    return new BufferedInputStream(new FileInputStream(zipFile));
                }

                public String getName() {
                    return simulationFile.getName() + ".zip";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            }));
        }


        String attachmentName = simulationFile.getName() + ".zip";
        attPart.setFileName(attachmentName);

        attPart.setDisposition(Part.ATTACHMENT);
        bodyMime.addBodyPart(attPart);

        BodyPart bodyPart = new MimeBodyPart();
        bodyPart.setText(text);
        bodyMime.addBodyPart(bodyPart);

        msg.setContent(bodyMime);

        // -- Set some other header information --
        msg.setHeader("X-Mailer", "Code Lutin Java Mailer");
        msg.setSentDate(new Date());

        // -- Send the message --
        Transport.send(msg);

        if (tmpDirectory != null) {
            if (!FileUtils.deleteQuietly(tmpDirectory)) {
                log.warn(t("isisfish.error.remove.directory", tmpDirectory));
            }
        }
    }
}
