/*
 * #%L
 * IsisFish
 * 
 * $Id: Export.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.export;

import java.io.Writer;

import fr.ifremer.isisfish.datastore.SimulationStorage;

/**
 * Interface que doivent implanter les classes d'export de resultats.
 * 
 * Le nom du fichier d'export qui sera utilisé sera le basé sur le nom de la
 * classe d'export
 * 
 * Created: 22 janv. 2006 21:12:58
 *
 * @author poussin
 * @version $Revision: 3798 $
 *
 * Last update: $Date: 2012-10-30 11:39:32 +0100 (Tue, 30 Oct 2012) $
 * by : $Author: echatellier $
 */
public interface Export {

    /**
     * Necessary results names for export execution.
     * 
     * @return the necessaryResult name
     */
    public String[] getNecessaryResult();

    /**
     * Return Export description.
     * 
     * @return string displayable to the end user
     */
    public String getDescription();

    /**
     * Return filename used to contains export data.
     * 
     * @return filename by example "myexport"
     */
    public String getExportFilename();

    /**
     * Return extension used as filename name extension.
     * 
     * @return extension by example ".csv"
     */
    public String getExtensionFilename();

    /**
     * Exporte les resultat.
     * 
     * @param simulation la simulation dont on souhaite exporter les resultats
     * @param out la sortie sur lequel il faut ecrire l'export
     * @throws Exception if export fail
     */
    public void export(SimulationStorage simulation, Writer out)
            throws Exception;

}
