package fr.ifremer.isisfish.ui.simulator;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.models.common.StringListModel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ResultChoiceUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz08TQRR+rbRQoKI0IkZIQGu8mK2eIQpiiDRFDY0JsRen3YEOmc6MM7OyeDD+Cf4Jevdi4s2T8eDZgxfjv2CMB6/GN7Olpbpqo3vY3bwf3/vee9978RlyRsPiHonjQEfCsg4Nqqvb27ebe7Rlb1DT0kxZqSF5MlnINmAi7NmNhfONmkuvdNMra7KjpKDiSPZSDcaNPeDUtCm1FuYHM1rGVOo991KsIn2I2iOVhvrs65fs0/DJ8yxArJCda2Xhb1n9TkZqkGWhhWms9JBUOBG7SEMzsYt8i862xokxt0iHPoDHMFqDvCIawSycG75lj+HzY2VhrFy9QwTlly1UdnTAdjTtUPwaZnaYaQcRCwzrRJwgRLBFTcTtWluyFr27oZSHyXuQGml6kGlHMw7MPrIOEqsLKvRii+VqvaUl564sJpweSOi7BrOmODM2Ke/axy2fHCyEbhc61csolKvXI2ulwBqlgdjE3MXXcHZgQbj6oL/6/m4yDcjpiLvKs41f1bKFrkQnsz/pxAF67/eZ0ofXn16tH4ojj7VPpYYe0TYuTWmpqLbMlZ5KlBFZxiubRC01oGAox8Pwwp9LIVbvupEc1vNDC1x6cJOYNkLkRj++eTtz//0xyK7DOJckXCcufgMKtq1xCpKHsbq24hlN7o/h+4TjZiHPyYHEUcLx5ZBYstBkIsT5Xo1xCHMpQ+gxaRbefSvVX64cDiKDxM78Nrw/jNw9yDPBmaD+TronkHoXE8rQKJR9qaeJP+O+46or43n/XkzrtNSWmj2SwhK+ytmu6PiTm15OyCwQizfajCzF1h3GBd+T+7voSxSHKDFiaewFfOnfMSZblPMtKkKqqXZR5XSs0hBYxURWTIpNGdL/AnPmK39obQYRfgANiGyw9wUAAA==";
    private static final Log log = LogFactory.getLog(ResultChoiceUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JList listResultNames;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ResultChoiceUI $JPanel0 = this;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            refresh();
        }
    
        public void refresh() {
        
            // FIXME listen for result name modification
    
            setListSimulResultChooseModel();
        }
    
        protected SimulAction getSimulAction() {
            return getContextValue(SimulAction.class);
        }
    
        protected void setListSimulResultChooseModel(){
    
            java.util.List<String> availableResults = getSimulAction().getResultNames();
            java.util.List<String> userResults = getSimulAction().getDefaultResultNames();
            // userResults = intersection(userResults,availableResult)
            userResults.retainAll(availableResults);
    
            StringListModel resultModel = new StringListModel(availableResults);
            listResultNames.setModel(resultModel);
    
            for (String userResult : userResults) {
                int index = availableResults.indexOf(userResult);
                listResultNames.addSelectionInterval(index, index);
            }
        }
    
        protected void saveParametersResultNames(ListSelectionEvent event) {
            getContextValue(SimulAction.class).saveParametersResultNames(listResultNames.getSelectedValues());
        }
      
        protected void saveConfigResultNames() {
            getContextValue(SimulAction.class).saveConfigurationResultNames(listResultNames.getSelectedValues());
            setStatusMessage(_("isisfish.resultChoice.saved"));
        }
    
        protected void setStatusMessage(String txt) {
            // TODO remove getParentContainer use
            WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
            root.setStatusMessage(txt);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ResultChoiceUI() {
        $initialize();
    }

    public ResultChoiceUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultChoiceUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ResultChoiceUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultChoiceUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ResultChoiceUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultChoiceUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ResultChoiceUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveConfigResultNames();
    }

    public void doValueChanged__on__listResultNames(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveParametersResultNames(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JList getListResultNames() {
        return listResultNames;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createListResultNames() {
        $objectMap.put("listResultNames", listResultNames = new JList());
        
        listResultNames.setName("listResultNames");
        listResultNames.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__listResultNames"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JLabel0, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listResultNames);
        
        // apply 3 property setters
        listResultNames.setCellRenderer(new fr.ifremer.isisfish.ui.models.result.ResultListRenderer());
        listResultNames.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setHorizontalAlignment(0);
        $JLabel0.setText(_("isisfish.resultChoice.save"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListResultNames();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("isisfish.common.saveNextSimulation"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}