/*
 * #%L
 * $Id: MatrixSummaryRenderer.java 3445 2011-07-15 13:12:45Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.1.1/src/main/java/fr/ifremer/isisfish/ui/result/MatrixSummaryRenderer.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

import java.awt.Component;
import java.util.Iterator;

import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.topia.TopiaContext;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.types.TimeStep;

/**
 * Simulation summary renderer.
 * 
 * @author chatellier
 * @version $Revision: 3445 $
 * 
 * Last update : $Date: 2011-07-15 15:12:45 +0200 (Fri, 15 Jul 2011) $
 * By : $Author: chatellier $
 */
public class MatrixSummaryRenderer implements MatrixRenderer {

    protected static final String ABONDANCE_STRING = n_("matrixAbundance");
    protected static final String CAPTUREPARMETIER_STRING = _("matrixCatchPerStrategyMetPerZoneMet");
    protected static final String REJETPARMETIER_STRING = _("matrixDiscardsPerStrMetPerZonePop");

    protected SimulationStorage simulationStorage;

    protected ResultStorage resultStorage;

    protected TopiaContext topiaContext;

    protected Component cachedComponent;

    public MatrixSummaryRenderer(SimulationStorage simulationStorage, ResultStorage resultStorage, TopiaContext topiaContext) {
        this.resultStorage = resultStorage;
        this.simulationStorage = simulationStorage;
        this.topiaContext = topiaContext;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getComponent(org.nuiton.math.matrix.MatrixND)
     */
    @Override
    public Component getComponent(MatrixND matrix) {
        if (cachedComponent == null) {

            SimulationParameter sp = simulationStorage.getParameter();
            StringBuffer resume = new StringBuffer(sp.toString());
            resume.append("\n");

            for(Iterator<String> i = resultStorage.getResultName().iterator(); i.hasNext();) {
                String name = (String)i.next();
                try {

                    // TODO EC20090717 ca marche plus ca
                    if (name.startsWith(ABONDANCE_STRING)){
                        MatrixND mat1 = resultStorage.getMatrix(new TimeStep(0), name, topiaContext);
                        mat1 = mat1.sumOverDim(0);
                        mat1 = mat1.sumOverDim(1);
                        mat1 = mat1.reduce();
                        resume.append(_("isisfish.result.begin.simulation")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
    
                        mat1 = resultStorage.getMatrix(resultStorage.getLastStep(), name, topiaContext);
                        mat1 = mat1.sumOverDim(0);
                        mat1 = mat1.sumOverDim(1);
                        mat1 = mat1.reduce();
                        resume.append(_("isisfish.result.end.simulation")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                    }
                    /*
                    un peu long
                    else if(name.startsWith(REJETPARMETIER_STRING)){
                        MatrixND mat1 = resultStorage.getMatrix(name, topiaContext);
                        mat1 = mat1.sumOverDim(0);
                        mat1 = mat1.sumOverDim(1);
                        mat1 = mat1.sumOverDim(2);
                        mat1 = mat1.sumOverDim(3);
    
                        mat1 = mat1.reduce();
                        resume.append(_("isisfish.common.sum")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                    }
                    else if (!name.startsWith(CAPTUREPARMETIER_STRING)){
                        MatrixND mat1 = resultStorage.getMatrix(name, topiaContext);
                        mat1 = mat1.sumOverDim(0);
                        mat1 = mat1.sumOverDim(1);
                        mat1 = mat1.sumOverDim(2);
    
                        mat1 = mat1.reduce();
                        resume.append(_("isisfish.common.sum")).append(mat1.getName()).append(": ").append(mat1.getValue(0)).append("\n");
                    }*/
                } catch (Exception eee) {
                    resume.append(_("isisfish.error.no.matrix", name));
                }
            }
            
            resume.append("\n\n");
            resume.append(simulationStorage.getInformation().toString());

            cachedComponent = new JScrollPane(new JTextArea(resume.toString()));
        }
        
        return cachedComponent;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getIcon()
     */
    @Override
    public Icon getIcon() {
        return null;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getName()
     */
    @Override
    public String getName() {
        return _("isisfish.result.summary");
    }
}
