/*
 * #%L
 * IsisFish
 * 
 * $Id: RuleParametersFactorTableCellEditor.java 3485 2011-10-24 15:34:37Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.1.1/src/main/java/fr/ifremer/isisfish/ui/models/rule/RuleParametersFactorTableCellEditor.java $
 * %%
 * Copyright (C) 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.rule;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputHandler;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.simulator.SimulAction;

/**
 * Specific editor for rule parameters.
 *
 * @author chatellier
 * @version $Revision: 3485 $
 * 
 * Last update : $Date: 2011-10-24 17:34:37 +0200 (Mon, 24 Oct 2011) $
 * By : $Author: chatellier $
 */
public class RuleParametersFactorTableCellEditor extends AbstractCellEditor
    implements TableCellEditor {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1655744662816030649L;

    private static Log log = LogFactory.getLog(RuleParametersFactorTableCellEditor.class);

    protected RuleChooser ruleChooser;

    protected Rule rule;

    /**
     * Constructor.
     * 
     * Super dependant de l'ui {@link RuleChooser} et de {@link SimulAction}.
     * 
     * @param ruleChooser rule chooser ui
     * @param rule rule
     */
    public RuleParametersFactorTableCellEditor(RuleChooser ruleChooser, Rule rule) {
        this.ruleChooser = ruleChooser;
        this.rule = rule;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int column) {

        Component comp = null;

        final String paramName = (String)value;
        try {
            Class paramType = RuleStorage.getParameterType(rule, paramName);
            SensitivityInputHandler handler = ruleChooser.getContextValue(SensitivityInputHandler.class);
            boolean canBeFactor = handler.canBeFactor(paramType);
            if (canBeFactor) {
                JButton button = new JButton(Resource.getIcon("/icons/building_add.png"));
                button.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        cancelCellEditing();
                        SimulAction simulAction = ruleChooser.getContextValue(SimulAction.class);
                        simulAction.addRuleParameterFactor(ruleChooser, rule, paramName);
                    }
                });
                comp = button;
            }
        } catch (IsisFishException ex) {
            if (log.isWarnEnabled()) {
                log.warn("Can't get value type", ex);
            }
        }

        if (comp == null) {
            comp = new JLabel();
        }

        return comp;
    }

    /*
     * @see javax.swing.CellEditor#getCellEditorValue()
     */
    @Override
    public Object getCellEditorValue() {
        return null;
    }
}
