/*
 * #%L
 * $Id: SensitivityUtils.java 3591 2012-01-12 15:02:42Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.1.1/src/main/java/fr/ifremer/isisfish/simulator/sensitivity/SensitivityUtils.java $
 * %%
 * Copyright (C) 2012 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.sensitivity;

import org.apache.commons.lang3.StringUtils;

/**
 * Utility methods for sensitivity analysis.
 * 
 * @author chatellier
 * @version $Revision: 3591 $
 * 
 * Last update : $Date: 2012-01-12 16:02:42 +0100 (Thu, 12 Jan 2012) $
 * By : $Author: echatellier $
 */
public class SensitivityUtils {

    /**
     * Escape factor name.
     * 
     * R don't like factor name with special characters such as "." and accents.
     * @param factorName factor name to escape
     * @return escaped factor name
     * @since 4.0.0.2
     */
    public static String espaceFactorName(String factorName) {
        String name = StringUtils.stripAccents(factorName);
        name = name.replaceAll("\\W", "_");
        return name;
    }
}
