/*
 * #%L
 * IsisFish
 * 
 * $Id: MetierMonitor.java 3735 2012-08-27 15:20:25Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator;

import static org.nuiton.i18n.I18n.n_;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.types.Month;

/**
 * ATTENTION: l'implantation de cette classe n'est peut-etre pas correct. Il faut
 * absolument verifier le FIXME, mais il est difficile de le faire car
 * la plupart des methodes de cette objets ne semble plus utilisé dans la
 * version 2.3.x de isis
 * 
 * Created: 21 août 2006 15:43:19
 *
 * @author poussin
 * @version $Revision: 3735 $
 *
 * Last update: $Date: 2012-08-27 17:20:25 +0200 (Mon, 27 Aug 2012) $
 * by : $Author: echatellier $
 */
public class MetierMonitor {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static Log log = LogFactory.getLog(MetierMonitor.class);

    protected Set<Metier> forbiddenMetier = new HashSet<Metier>();
    protected Set<MultiKey> forbiddenMetierMonth = new HashSet<MultiKey>();
    protected Map<TimeStep, MatrixND> noActivity = new HashMap<TimeStep, MatrixND>();
    
    /**
     * clear all data
     * 
     * can be used at end of each simulation step
     */
    public void clear() {
        list.clear();
        forbiddenMetier.clear();
    }
    
    /**
     * Add forbidden metier, this metier is remove when {@link #clear()} is called
     * 
     * @param metier
     */
    public void addforbiddenMetier(Metier metier) {
        forbiddenMetier.add(metier);
    }

    /**
     * Add forbidden metier, this metier is not remove when {@link #clear()} is called
     * 
     * @param metier
     * @param month
     */
    public void addforbiddenMetier(Metier metier, Month month) {
        forbiddenMetierMonth.add(new MultiKey(metier, month));
    }
    
    public void removeforbiddenMetier(Metier metier, Month month) {
        forbiddenMetierMonth.remove(new MultiKey(metier, month));
    }

    public void addforbiddenMetier(Collection<Metier> metiers) {
        forbiddenMetier.addAll(metiers);
    }
        
    /**
     * @return Returns the forbiddenMetier.
     */
    public Set<Metier> getForbiddenMetier() {
        return this.forbiddenMetier;
    }
    
    /**
     * Metier is forbidden is can be found in {@link #forbiddenMetier} or in
     * {@link #forbiddenMetierMonth}.
     * 
     * @param metier
     * @param month
     * @return {@code true} if metier forbidden
     */
    public boolean isForbidden(Metier metier, Month month) {
        boolean result = forbiddenMetier.contains(metier);
        if (!result) {
            result = forbiddenMetierMonth.contains(new MultiKey(metier, month));
        }
        return result;
    }

    
    /**
     * @return Returns the nonActivity.
     */
    public MatrixND getNoActivity(TimeStep step) {
        return this.noActivity.get(step);
    }
    
    public MatrixND getOrCreateNoActivity(TimeStep step, String name, List<Strategy> strategies, List<Metier> metiers) {
        MatrixND result = getNoActivity(step);
        if (result == null){
            if (strategies.size() == 0) {
                strategies = new ArrayList<Strategy>();
                strategies.add(null);
            }
            
            if (metiers.size() == 0) {
                metiers = new ArrayList<Metier>();
                metiers.add(null);
            }
            
            result = MatrixFactory.getInstance().create(
                    name,
                    new List[] {strategies, metiers},
                    new String[] {n_("isisfish.metierMonitor.strategies"), n_("isisfish.metierMonitor.metiers")});
            setNoActivity(step, result);
        }
        return result;
    }
    
    /**
     * @param nonActivity The nonActivity to set.
     */
    public void setNoActivity(TimeStep step, MatrixND nonActivity) {
        this.noActivity.put(step, nonActivity);
    }
    
    //////////////////////////////////////////////////////////////////////////
    //
    // FIXME Next method must be verified or removed
    //
    //////////////////////////////////////////////////////////////////////////

    /** key <Metier, Month, Month> value: <Licence> */
    protected MultiKeyMap list = new MultiKeyMap();

    class Licence {
        int nbLicences = 0;
        double proportionMaxTotal = 0;
        Map<Month, Double> proportionsMonth = new HashMap<Month, Double>();
    }
    
    public Licence getLicence(Metier metier, Month month) {
        Licence result = null;
        for (MapIterator i=list.mapIterator(); i.hasNext();) {
            MultiKey keys = (MultiKey)i.next();
            Metier metierKey = (Metier)keys.getKey(0);
            Month firstMonth = (Month)keys.getKey(1);
            Month lastMonth = (Month)keys.getKey(2);
            if (metier.equals(metierKey)
                    && firstMonth.compareTo(month) <= 0
                    && month.compareTo(lastMonth) <= 0) {
                result = (Licence)i.getValue();
                break;
            }
        }
        return result;
    }
    
    public void addLicence(Metier metier, int nbLicences, Month firstMonth, Month lastMonth) {
        if (!isLimitedPeriode(metier, firstMonth, lastMonth)) {
            Licence o = new Licence();
            o.nbLicences = nbLicences;
            o.proportionMaxTotal = this.computeProportionMaxTotal(metier, nbLicences);

            for (Month i=firstMonth; i.compareTo(lastMonth) <= 0; i=i.next()) {
                o.proportionsMonth.put(i, computeProportionMonth(metier, i));

            }
            
            this.list.put(metier, firstMonth, lastMonth, o);

          }
          else{
              log.warn("il existe deja une licence touchant le metier: " + metier
                    + " sur la periode:"+ firstMonth + "-" + lastMonth);
          }
    }
    
    /**
     * @param metier
     * @param firstMonth
     * @param lastMonth
     * @return limited period
     */
    public boolean isLimitedPeriode(Metier metier, Month firstMonth, Month lastMonth) {
        for(Month i = firstMonth; i.compareTo(lastMonth) <= 0; i = i.next()) {
            if (isLimited(metier, i)) {
                return true;
            }
        }
        return false;
    }

    public boolean isLimited(Metier metier, Month month) {
        Licence l = getLicence(metier, month);
        return l != null;
    }

    public double getLicenceOverflow(Metier metier, Month month) {
        Licence licence = this.getLicence(metier, month);
        if (licence != null) {
          double propMax = licence.proportionMaxTotal;
          double prop = licence.proportionsMonth.get(month);

          if(propMax<prop)
            return prop-propMax;
        }
        return 0;
    }
    
    /**
     * @param metier
     * @param i
     * @return proportion month
     */
    private double computeProportionMonth(Metier metier, Month month) {
        double prop = 0;

        try {
            TopiaContext tx = metier.getTopiaContext();
            List<StrategyMonthInfo> res = null;
            // FIXME, c faux car il ne faut prendre que les str selectionnée pour la simulation
            res = tx.findAll("select * from fr.ifremer.isisfish.entities.StrategyMonthInfo where strategyMonthInfo.month=?",
                    month, metier);
            
            for(StrategyMonthInfo smi : res){
                prop = prop + smi.getProportionMetier(metier);
            }
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't find PropStrMet", eee);
        }

        return prop;

    }

    /**
     * @param metier
     * @param nbLicences
     * @return proportion max total
     */
    private double computeProportionMaxTotal(Metier metier, int nbLicences) {
        int nbBoat = 0;

        try {
            // FIXME: Cette methode n'existe pas dans L'ECMAScript :(
//      strategies = Regle_libUtil.getStrategiesMetier(metier);
            // Je l'ai traduit avec ce qui suit        
            TopiaContext tx = metier.getTopiaContext();
            List<SetOfVessels> res = null;
            // FIXME, c faux car il ne faut prendre que les str selectionnée pour la simulation
            res = tx.findAll("select setOfVessels from fr.ifremer.isisfish.entities.EffortDescription where possibleMetiers=?",
                    metier);

            for(SetOfVessels sov : res){
                nbBoat = nbBoat + sov.getNumberOfVessels();
            }
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't find SetOfVessels", eee);
        }
        
        double result = 0;
        if (nbBoat != 0) {
            result = nbLicences / (double)nbBoat;
        }

        return result;

    }
}
