/*
 * #%L
 * IsisFish
 * 
 * $Id: FactorGroupXMLVisitor.java 3489 2011-10-25 16:51:12Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.1.1/src/main/java/fr/ifremer/isisfish/mexico/xml/FactorGroupXMLVisitor.java $
 * %%
 * Copyright (C) 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorGroupVisitor;

/**
 * XML factor group visitor.
 *
 * @author chatellier
 * @version $Revision: 3489 $
 * 
 * Last update : $Date: 2011-10-25 18:51:12 +0200 (Tue, 25 Oct 2011) $
 * By : $Author: chatellier $
 */
public class FactorGroupXMLVisitor extends AbstractXMLVisitor implements FactorGroupVisitor {

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorGroupVisitor#start(fr.ifremer.isisfish.simulator.sensitivity.FactorGroup)
     */
    @Override
    public void start(FactorGroup factorGroup) {
        xmlBuffer.append("<factors");
        if (factorGroup.getName() != null) {
            xmlBuffer.append(" name=\"" + factorGroup.getName() + "\"");
        }
        if (factorGroup.isContinuous()) {
            xmlBuffer.append(" type=\"continuous\"");
        } else {
            xmlBuffer.append(" type=\"discrete\"");
        }
        xmlBuffer.append(">");
    }

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorGroupVisitor#visit(fr.ifremer.isisfish.simulator.sensitivity.FactorGroup, fr.ifremer.isisfish.simulator.sensitivity.Factor)
     */
    @Override
    public void visit(FactorGroup factorGroup, Factor factor) {
        if (factor instanceof FactorGroup) {
            FactorGroup factorGroup2 = (FactorGroup)factor;
            FactorGroupXMLVisitor visitor = new FactorGroupXMLVisitor();
            factorGroup2.accept(visitor);
            xmlBuffer.append(visitor.getXML());
        }
        else {
            FactorXMLVisitor visitor = new FactorXMLVisitor();
            factor.accept(visitor);
            xmlBuffer.append(visitor.getXML());
        }
    }

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorGroupVisitor#end(fr.ifremer.isisfish.simulator.sensitivity.FactorGroup)
     */
    @Override
    public void end(FactorGroup factorGroup) {
        xmlBuffer.append("</factors>");
    }
}
