package fr.ifremer.isisfish.entities;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SelectivityAbstract extends TopiaEntityAbstract implements Selectivity {

    /**
     * Nom de l'attribut en BD : equation
     */
    protected Equation equation;

    /**
     * Nom de l'attribut en BD : gear
     */
    protected Gear gear;

    /**
     * Nom de l'attribut en BD : population
     */
    protected Population population;

    private static final long serialVersionUID = 3846746108401574451L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Selectivity.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Selectivity.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_EQUATION, Equation.class, equation);
        visitor.visit(this, PROPERTY_GEAR, Gear.class, gear);
        visitor.visit(this, PROPERTY_POPULATION, Population.class, population);
        visitor.end(this);
    }

    @Override
    public void setEquation(Equation equation) {
        Equation oldValue = this.equation;
        fireOnPreWrite(PROPERTY_EQUATION, oldValue, equation);
        this.equation = equation;
        fireOnPostWrite(PROPERTY_EQUATION, oldValue, equation);
    }

    @Override
    public Equation getEquation() {
        fireOnPreRead(PROPERTY_EQUATION, equation);
        Equation result = this.equation;
        fireOnPostRead(PROPERTY_EQUATION, equation);
        return result;
    }

    @Override
    public void setGear(Gear gear) {
        Gear oldValue = this.gear;
        fireOnPreWrite(PROPERTY_GEAR, oldValue, gear);
        this.gear = gear;
        fireOnPostWrite(PROPERTY_GEAR, oldValue, gear);
    }

    @Override
    public Gear getGear() {
        fireOnPreRead(PROPERTY_GEAR, gear);
        Gear result = this.gear;
        fireOnPostRead(PROPERTY_GEAR, gear);
        return result;
    }

    @Override
    public void setPopulation(Population population) {
        Population oldValue = this.population;
        fireOnPreWrite(PROPERTY_POPULATION, oldValue, population);
        this.population = population;
        fireOnPostWrite(PROPERTY_POPULATION, oldValue, population);
    }

    @Override
    public Population getPopulation() {
        fireOnPreRead(PROPERTY_POPULATION, population);
        Population result = this.population;
        fireOnPostRead(PROPERTY_POPULATION, population);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getEquation());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_EQUATION, this.equation).
         toString();
        return result;
    }

} //SelectivityAbstract
