/*
 * #%L
 * IsisFish
 * 
 * $Id: SeasonImpl.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;

import fr.ifremer.isisfish.types.Month;
import static org.nuiton.i18n.I18n._;

/***
 * SeasonImpl.
 *
 * Created: 3 janv. 2006 18:28:19
 *
 * @author poussin
 * @version $Revision: 3124 $
 *
 * Last update: $Date: 2010-11-29 19:14:09 +0100 (Mon, 29 Nov 2010) $
 * by : $Author: chatellier $
 */
public class SeasonImpl extends SeasonAbstract {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public SeasonImpl() {
        super();
        setFirstMonth(Month.JANUARY);
        setLastMonth(Month.JANUARY);
    }

    /* (non-Javadoc)
     * @see fr.ifremer.isisfish.entities.Season#getMonths()
     */
    public List<Month> getMonths() {
        List<Month> result = new ArrayList<Month>();
        Month m = getFirstMonth();
        while (m.equals(getLastMonth()) == false) {
            result.add(m);
            m = m.next();
        }
        result.add(m); // add last month because we exit loop before
        return result;
    }

    /* (non-Javadoc)
     * @see fr.ifremer.isisfish.entities.Season#setMonths(java.util.List)
     */
    public void setMonths(List<Month> listMonth) {
        if (listMonth == null || listMonth.size() == 0) {
            throw new IllegalArgumentException(
                    "listMonth must contains one month or more");
        }
        Month first = listMonth.get(0);
        Month last = listMonth.get(listMonth.size() - 1);

        setFirstMonth(first);
        setLastMonth(last);
    }

    /* (non-Javadoc)
     * @see fr.ifremer.isisfish.entities.Season#containsMonth(fr.ifremer.isisfish.types.Month)
     */
    public boolean containsMonth(Month month) {
        boolean result = month.equals(getLastMonth()); // check first last month, because loop don't do that

        Month m = getFirstMonth();
        while (result == false && m.equals(getLastMonth()) == false) {
            result = m.equals(month);
            m = m.next();
        }
        return result;
    }

    /* (non-Javadoc)
     * @see fr.ifremer.isisfish.entities.SeasonAbstract#toString()
     */
    @Override
    public String toString() {
        String result = _("isisfish.season.toString", this.getFirstMonth(),
                this.getLastMonth());
        return result;
    }

}
