package fr.ifremer.isisfish.entities;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.types.Month;
import java.util.List;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public interface Population extends TopiaEntityContextable {

    String PROPERTY_NAME = "name";

    String PROPERTY_GEOGRAPHIC_ID = "geographicId";

    String PROPERTY_PLUS_GROUP = "plusGroup";

    String PROPERTY_GROWTH = "growth";

    String PROPERTY_GROWTH_REVERSE = "growthReverse";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_MEAN_WEIGHT = "meanWeight";

    String PROPERTY_PRICE = "price";

    String PROPERTY_NATURAL_DEATH_RATE = "naturalDeathRate";

    String PROPERTY_CARACT_BIO_COMMENT = "caractBioComment";

    String PROPERTY_REPRODUCTION_EQUATION = "reproductionEquation";

    String PROPERTY_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT = "monthGapBetweenReproRecrutement";

    String PROPERTY_RECRUITMENT_DISTRIBUTION = "recruitmentDistribution";

    String PROPERTY_RECRUITMENT_COMMENT = "recruitmentComment";

    String PROPERTY_ZONES_COMMENT = "zonesComment";

    String PROPERTY_SEASONS_COMMENT = "seasonsComment";

    String PROPERTY_CAPTURABILITY_COMMENT = "capturabilityComment";

    String PROPERTY_MIGRATION_COMMENT = "migrationComment";

    String PROPERTY_MAPPING_ZONE_REPRO_ZONE_RECRU = "mappingZoneReproZoneRecru";

    String PROPERTY_CAPTURABILITY = "capturability";

    String PROPERTY_CAPTURABILITY_EQUATION_USED = "capturabilityEquationUsed";

    String PROPERTY_CAPTURABILITY_EQUATION = "capturabilityEquation";

    String PROPERTY_MATURITY_OGIVE_EQUATION = "maturityOgiveEquation";

    String PROPERTY_REPRODUCTION_RATE_EQUATION = "reproductionRateEquation";

    String PROPERTY_GEAR_SELECTIVITY = "gearSelectivity";

    String PROPERTY_POPULATION_GROUP = "populationGroup";

    String PROPERTY_POPULATION_SEASON_INFO = "populationSeasonInfo";

    String PROPERTY_SPECIES = "species";

    String PROPERTY_REPRODUCTION_ZONE = "reproductionZone";

    String PROPERTY_POPULATION_ZONE = "populationZone";

    String PROPERTY_RECRUITMENT_ZONE = "recruitmentZone";

    void setName(String name);

    String getName();

    void setGeographicId(String geographicId);

    String getGeographicId();

    void setPlusGroup(boolean plusGroup);

    boolean isPlusGroup();

    boolean getPlusGroup();

    void setGrowth(Equation growth);

    Equation getGrowth();

    void setGrowthReverse(Equation growthReverse);

    Equation getGrowthReverse();

    void setComment(String comment);

    String getComment();

    void setMeanWeight(Equation meanWeight);

    Equation getMeanWeight();

    void setPrice(Equation price);

    Equation getPrice();

    void setNaturalDeathRate(Equation naturalDeathRate);

    Equation getNaturalDeathRate();

    void setCaractBioComment(String caractBioComment);

    String getCaractBioComment();

    void setReproductionEquation(Equation reproductionEquation);

    Equation getReproductionEquation();

    void setMonthGapBetweenReproRecrutement(int monthGapBetweenReproRecrutement);

    int getMonthGapBetweenReproRecrutement();

    void setRecruitmentDistribution(MatrixND recruitmentDistribution);

    MatrixND getRecruitmentDistribution();

    void setRecruitmentComment(String recruitmentComment);

    String getRecruitmentComment();

    void setZonesComment(String zonesComment);

    String getZonesComment();

    void setSeasonsComment(String seasonsComment);

    String getSeasonsComment();

    void setCapturabilityComment(String capturabilityComment);

    String getCapturabilityComment();

    void setMigrationComment(String migrationComment);

    String getMigrationComment();

    void setMappingZoneReproZoneRecru(MatrixND mappingZoneReproZoneRecru);

    MatrixND getMappingZoneReproZoneRecru();

    void setCapturability(MatrixND capturability);

    MatrixND getCapturability();

    void setCapturabilityEquationUsed(boolean capturabilityEquationUsed);

    boolean isCapturabilityEquationUsed();

    boolean getCapturabilityEquationUsed();

    void setCapturabilityEquation(Equation capturabilityEquation);

    Equation getCapturabilityEquation();

    void setMaturityOgiveEquation(Equation maturityOgiveEquation);

    Equation getMaturityOgiveEquation();

    void setReproductionRateEquation(Equation reproductionRateEquation);

    Equation getReproductionRateEquation();

    void addPopulationGroup(PopulationGroup populationGroup);

    void addAllPopulationGroup(List<PopulationGroup> populationGroup);

    void setPopulationGroup(List<PopulationGroup> populationGroup);

    void removePopulationGroup(PopulationGroup populationGroup);

    void clearPopulationGroup();

    List<PopulationGroup> getPopulationGroup();

    PopulationGroup getPopulationGroupByTopiaId(String topiaId);

    int sizePopulationGroup();

    boolean isPopulationGroupEmpty();

    void addPopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo);

    void addAllPopulationSeasonInfo(List<PopulationSeasonInfo> populationSeasonInfo);

    void setPopulationSeasonInfo(List<PopulationSeasonInfo> populationSeasonInfo);

    void removePopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo);

    void clearPopulationSeasonInfo();

    List<PopulationSeasonInfo> getPopulationSeasonInfo();

    PopulationSeasonInfo getPopulationSeasonInfoByTopiaId(String topiaId);

    int sizePopulationSeasonInfo();

    boolean isPopulationSeasonInfoEmpty();

    void setSpecies(Species species);

    Species getSpecies();

    void addReproductionZone(Zone reproductionZone);

    void addAllReproductionZone(List<Zone> reproductionZone);

    void setReproductionZone(List<Zone> reproductionZone);

    void removeReproductionZone(Zone reproductionZone);

    void clearReproductionZone();

    List<Zone> getReproductionZone();

    Zone getReproductionZoneByTopiaId(String topiaId);

    int sizeReproductionZone();

    boolean isReproductionZoneEmpty();

    void addPopulationZone(Zone populationZone);

    void addAllPopulationZone(List<Zone> populationZone);

    void setPopulationZone(List<Zone> populationZone);

    void removePopulationZone(Zone populationZone);

    void clearPopulationZone();

    List<Zone> getPopulationZone();

    Zone getPopulationZoneByTopiaId(String topiaId);

    int sizePopulationZone();

    boolean isPopulationZoneEmpty();

    void addRecruitmentZone(Zone recruitmentZone);

    void addAllRecruitmentZone(List<Zone> recruitmentZone);

    void setRecruitmentZone(List<Zone> recruitmentZone);

    void removeRecruitmentZone(Zone recruitmentZone);

    void clearRecruitmentZone();

    List<Zone> getRecruitmentZone();

    Zone getRecruitmentZoneByTopiaId(String topiaId);

    int sizeRecruitmentZone();

    boolean isRecruitmentZoneEmpty();

    PopulationSeasonInfo getPopulationSeasonInfo(Month month);

    MatrixND N2DToN1D(MatrixND m);

    MatrixND split2D(MatrixND m);

    double getNaturalDeathBirth(Zone zone);

    double getAge(double length, PopulationGroup group);

    double getLength(double age, PopulationGroup group);

    MatrixND getNaturalDeathRateMatrix();

} //Population
