/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2009 Ifremer, Code Lutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.actions;

import java.io.File;
import java.util.Arrays;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.isisfish.IsisConfig;

/**
 * VCS actions.
 * 
 * @author poussin
 * @version $Revision: 1862 $
 *
 * Last update: $Date: 2009-02-23 16:42:34 +0100 (lun. 23 févr. 2009) $
 * by : $Author: chatellier $
 */
public class VCSAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(VCSAction.class);

    protected IsisConfig config = null;

    public VCSAction(IsisConfig config) {
        this.config = config;
    }

    public void vcsUpdate() throws Exception {
        // ATTENTION: il est inutile de d'accepter cette option au premier
        // lancement! car on a effectue soit un checkout, soit
        // une migration
        // !IsisContext.get().isFirstLaunch()
        // Welcome.updateVCS(null);
    }

    public void vcsAdd(File ... file) throws Exception {
        log.info("file*:" + Arrays.toString(file));
        throw new UnsupportedOperationException("to be done...");
    }

    public void vcsRemove(File ... file) throws Exception {
        log.info("file*:" + Arrays.toString(file));
        throw new UnsupportedOperationException("to be done...");
    }

    public void vcsCommit(File ... file) throws Exception {
        log.info("file*:" + Arrays.toString(file));
        throw new UnsupportedOperationException("to be done...");
    }

}
