/*
 * #%L
 * $Id: IsisMatrixSemanticMapper.java 3507 2011-10-28 13:47:33Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.1/src/main/java/fr/ifremer/isisfish/util/IsisMatrixSemanticMapper.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.SemanticMapper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaDAO;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.simulator.SimulationContext;

/**
 * Implementation du mapper de semantique pour Isis pour que l'import/export
 * des matrices en N dimensions de nuiton matrix fonctionne.
 * 
 * @author chatellier
 * @version $Revision: 3507 $
 * 
 * Last update : $Date: 2011-10-28 15:47:33 +0200 (Fri, 28 Oct 2011) $
 * By : $Author: echatellier $
 */
public class IsisMatrixSemanticMapper extends SemanticMapper {

    /** Logger for this class. */
    private static Log log = LogFactory.getLog(IsisMatrixSemanticMapper.class);

    /**
     * Return class for type identified by typeName.
     * 
     * For example : "Population" can return "fr.ifremer.entities.Population.class"
     * 
     * Return {@code String} by default.
     * 
     * @param typeName type to get class.
     * @return type for typeId
     */
    public Class getType(String typeName) {

        // In simulation context :
        Class clazz = null;
        try {
            clazz = Class.forName("fr.ifremer.isisfish.entities." + typeName);
        } catch (Exception ex) {
            log.warn("Can't find class for " + typeName, ex);
            clazz = String.class;
        }
        return clazz;
    }

    /**
     * Return value identified by valueId and type {@code type}.
     * 
     * Return {@code valueId} by default;
     * 
     * @param type
     * @param valueId
     * @return value identified by {valueId}
     */
    public Object getValue(Class type, String valueId) {

        // In simulation context :
        Object value = null;
        try {
            TopiaContext context = SimulationContext.get().getDB();
            TopiaDAO dao = IsisFishDAOHelper.getDAO(context, type);
            value = dao.findByProperty("name", valueId);
        } catch (Exception ex) {
            log.warn("Can't get value for " + valueId, ex);
            value = valueId;
        }
        return value;

        //return valueId;
    }
}
