/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.vcs;

import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class VCSConfigUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SERVER_LOGIN_ENABLED = "serverLogin.enabled";
    public static final String BINDING_SERVER_LOGIN_LABEL_ENABLED = "serverLoginLabel.enabled";
    public static final String BINDING_SERVER_LOGIN_NO_PASS_PHRASE_LABEL_ENABLED = "serverLoginNoPassPhraseLabel.enabled";
    public static final String BINDING_SERVER_NO_PASS_PHRASE_ENABLED = "serverNoPassPhrase.enabled";
    public static final String BINDING_SERVER_PRIVATE_KEY_CHANGE_FILE_ENABLED = "serverPrivateKeyChangeFile.enabled";
    public static final String BINDING_SERVER_PRIVATE_KEY_FILE_ENABLED = "serverPrivateKeyFile.enabled";
    public static final String BINDING_SERVER_PRIVATE_KEY_FILE_LABEL_ENABLED = "serverPrivateKeyFileLabel.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSemOaHkzQNCU3T4oqUmCIQrEOFhCAlJHFw2+CWULcQ8IXx7sQ77Xhm2Zl1NyAhDvwBXLjDnQsSN06IA+ceuCD+BYQ49Ip4s2uvvWa9Xmlz8Drz3vfN972Zfc8//IWmpYuuPMC+b7geV7RDjMO94+P3Ww+IqQ6INF3qKOGi8G+qgApNtGBF61KhzWZdwys9eKUqOo7ghA+ht+toXqpTRqRNiFLochxhSllpROFt3/HcPmskKon1u3/+LnxjffV9ASHfAXUlsLIxCTVwcqaOCtRSaAV26uIKw7wNMlzK26D3rF6rMizlHdwhn6Ev0WwdzTjYBTKFns9uOeAI8L6jULF8eEAxE+0tha6euAY9cUmHwFNSeUKlbXjU6JrS+LDaqAp+Qtv3bzlOAJ9RaLZ8D7cYAeh6zKV8BJqNIKYzixHgbPmwYbqCsSPMNeyCNuX38odCOn0xQs3bhDnvWhRcjELC1T7kXARZOqFwFThUqo5bhEFNY7BgMb5JMUIotBZLvkd8VaOEWXHAkq7jYAu9emGEMsrQC5dGTJEOpmwcdDqIJsCek8TtEnfPUzYcLzWxooLfJsoW1jiuufKhLhDbGq1CsBrP3RxPv8cFP+0ITwanPURzF1tU7HtKCa5ZXojILo8na0hbJ70cByyHgLpoUz7OzcJQTkJ9SkPhO+IIDuDIdrEce0YrYf5wqkLnY/6qNjEf7gs/DrwYAo9c2sWKvEdOa5SN3eWZpOQE9f2jek3//2I8dmmUo2pDgyCaSaHVmOLBYbwVwddH4TcIJy581fGdeG5fxrUEGQXxMELsDe6rS6BwCYFFE3OTsD1Tn31SPJQV3groYwl9RLf/0NENV3gOtB8XPRvLg35tDPr1oKFONUGYB8tgv/n/Fn8XQmFzXx9p7powiP67tvr7z3/+VOt39E3Y+3xi6tBAgk7ruMIhrqJ663NhO/cUZZXb2NluoqIkDKZZMK1KCcIavTCIg/2e1nBDw42bWNpAMT37xy+/rn36+ClUqKF5JrBVwzr/FioqG07CFszynXd2A0WLj+bgc1lrU2jGJrRtw8BYuU45o5xsYAUTpuUpsuNDIUoJhYjUtIq/PVlt/LjbL8YUiLs4Nn1QkOlP0Ey4WzDgerMrcaAtOJJ4lhjMqKSpNaWfy05vDn0QfN5PcjtHYDz0p9Cx7+nHx4Fw/a0Z8Kxm4DmjYASkcKxN5NDLVgpDKTfDRm6GcoZKzDB8KuBdREvXLazwRotyC97RnWTGqxkYF1qDVztF3Eu57U1mgDbWxcxLuy3ZZHyRwvBKbiPZGL7OxQC/7QjXb04gpJtMY+S2ko3h2xQNW7kZruV2kY0hTcPrWZpZODRImpLJPJOUvJG7GpMZ4HKZgnkdLlNo3sxtZTKD/tUvuHpV0s/TXvpsUj7KzeClmNnOXY63c59sfobd3HXYz16HMRoOcrvIz1DLzXATGP4DlShcVS0RAAA=";
    private static final Log log = LogFactory.getLog(VCSConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelAction;
    protected JTextField email;
    protected JLabel emailLabel;
    protected JTextField firstname;
    protected JLabel firstnameLabel;
    protected JEditorPane helpEditor;
    protected JTextField lasstname;
    protected JLabel lasstnameLabel;
    protected JButton ok;
    protected JButton reset;
    protected JRadioButton serverAuthenticationMethodAnonymous;
    protected JLabel serverAuthenticationMethodLabel;
    protected JRadioButton serverAuthenticationMethodSsh;
    protected JTextField serverLogin;
    protected JLabel serverLoginLabel;
    protected JLabel serverLoginNoPassPhraseLabel;
    protected JAXXButtonGroup serverMethod;
    protected JCheckBox serverNoPassPhrase;
    protected JButton serverPrivateKeyChangeFile;
    protected JTextField serverPrivateKeyFile;
    protected JLabel serverPrivateKeyFileLabel;
    protected JButton serverPrivateKeyGenerate;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VCSConfigUI $JDialog0 = this;
    private Table $Table0;
    private JScrollPane $JScrollPane0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public boolean cancel;
    protected boolean invalidFirstName;
    protected boolean invalidLastName;
    protected boolean invalidKey;
    protected boolean invalidEmail;
    protected boolean invalidLogin;
    private String oldEmail;
    private String oldServerLogin;
    private boolean oldUseSsh;
    private boolean oldNoPassPhrase;
    private String oldLastname;
    private String oldFirstname;
    private String oldServerPrivateKeyFile;
    
            
        protected void init() {
            String REGISTER_KEY_URL = "https://labs.libre-entreprise.org/account/editsshkeys.php";
            String DOC_URL = "http://isis-fish.labs.libre-entreprise.org/isis-fish/v3/user/addSshKey.html";
    
            StringBuilder builder = new StringBuilder();
            builder.append("<a href='").append(DOC_URL).append("'>");
            builder.append(_("isisfish.vcs.howto.save.key")).append("</a><br/>");
            builder.append("<a href='").append(REGISTER_KEY_URL).append("'>");
            builder.append(_("isisfish.vcs.save.key")).append("</a>");
    
            helpEditor.setEditorKit(new HTMLEditorKit());
            helpEditor.setText(builder.toString());
        }
    
        protected void saveOld() {
            this.oldFirstname=firstname.getText();
            this.oldLastname=lasstname.getText();
            this.oldEmail =email.getText();
            this.oldServerLogin=serverLogin.getText();
            this.oldServerPrivateKeyFile=serverPrivateKeyFile.getText();
            this.oldUseSsh=serverAuthenticationMethodSsh.isSelected();
            this.oldNoPassPhrase =serverNoPassPhrase.isSelected();
            doCheck();
        }
    
        protected void restoreOld() {
            firstname.setText(oldFirstname);
            lasstname.setText(oldLastname);
            email.setText(oldEmail);
            serverLogin.setText(oldServerLogin);
            serverPrivateKeyFile.setText(oldServerPrivateKeyFile);
            serverAuthenticationMethodSsh.setSelected(oldUseSsh);
            serverNoPassPhrase.setSelected(oldNoPassPhrase);
            doCheck();
        }
        public boolean isConfigValid() {
            return check(serverAuthenticationMethodSsh.isSelected());
        }
    
        protected boolean check(boolean ssh) {
            invalidFirstName=firstname.isVisible() && firstname.getText().isEmpty();
            invalidLastName=lasstname.isVisible() && lasstname.getText().isEmpty();
            invalidEmail=email.isVisible() && email.getText().isEmpty();
            if (ssh) {
                String file = serverPrivateKeyFile.getText();
                invalidKey=file.isEmpty() || !new java.io.File(file).exists();
                invalidLogin=serverLogin.getText().isEmpty();
            } else {
                invalidLogin=false;
                invalidKey=false;
            }
            return !(invalidEmail||invalidFirstName||invalidLastName||invalidLogin||invalidKey);
        }
    
        protected void doCheck() {
            boolean ssh = serverAuthenticationMethodSsh.isSelected();
            ok.setEnabled(check(ssh));
            if (ssh) {
                serverPrivateKeyGenerate.setEnabled(!invalidLogin);
            } else {
                serverPrivateKeyGenerate.setEnabled(false);
            }        
            setColor(invalidFirstName, firstnameLabel);
            setColor(invalidLastName, lasstnameLabel);
            setColor(invalidEmail, emailLabel);
            setColor(invalidLogin, serverLoginLabel);
            setColor(invalidKey, serverPrivateKeyFileLabel);
        }
    
        protected void setColor(boolean invalid, JComponent component) {
            component.setForeground(invalid ? Color.red: Color.black);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VCSConfigUI() {
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Window param0) {
        super(param0);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSConfigUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VCSConfigUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelAction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        cancel = true;dispose();
    }

    public void doActionPerformed__on__reset(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        restoreOld();
    }

    public void doActionPerformed__on__serverAuthenticationMethodAnonymous(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doActionPerformed__on__serverAuthenticationMethodSsh(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__email(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__firstname(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__lasstname(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__serverLogin(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__serverNoPassPhrase(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__serverPrivateKeyFile(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelAction() {
        return cancelAction;
    }

    public JTextField getEmail() {
        return email;
    }

    public JLabel getEmailLabel() {
        return emailLabel;
    }

    public JTextField getFirstname() {
        return firstname;
    }

    public JLabel getFirstnameLabel() {
        return firstnameLabel;
    }

    public JEditorPane getHelpEditor() {
        return helpEditor;
    }

    public JTextField getLasstname() {
        return lasstname;
    }

    public JLabel getLasstnameLabel() {
        return lasstnameLabel;
    }

    public JButton getOk() {
        return ok;
    }

    public JButton getReset() {
        return reset;
    }

    public JRadioButton getServerAuthenticationMethodAnonymous() {
        return serverAuthenticationMethodAnonymous;
    }

    public JLabel getServerAuthenticationMethodLabel() {
        return serverAuthenticationMethodLabel;
    }

    public JRadioButton getServerAuthenticationMethodSsh() {
        return serverAuthenticationMethodSsh;
    }

    public JTextField getServerLogin() {
        return serverLogin;
    }

    public JLabel getServerLoginLabel() {
        return serverLoginLabel;
    }

    public JLabel getServerLoginNoPassPhraseLabel() {
        return serverLoginNoPassPhraseLabel;
    }

    public JAXXButtonGroup getServerMethod() {
        return serverMethod;
    }

    public JCheckBox getServerNoPassPhrase() {
        return serverNoPassPhrase;
    }

    public JButton getServerPrivateKeyChangeFile() {
        return serverPrivateKeyChangeFile;
    }

    public JTextField getServerPrivateKeyFile() {
        return serverPrivateKeyFile;
    }

    public JLabel getServerPrivateKeyFileLabel() {
        return serverPrivateKeyFileLabel;
    }

    public JButton getServerPrivateKeyGenerate() {
        return serverPrivateKeyGenerate;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToServerAuthenticationMethodAnonymous() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = serverMethod; serverAuthenticationMethodAnonymous.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(serverAuthenticationMethodAnonymous); }
    }

    protected void addChildrenToServerAuthenticationMethodSsh() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = serverMethod; serverAuthenticationMethodSsh.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(serverAuthenticationMethodSsh); }
    }

    protected void createCancelAction() {
        $objectMap.put("cancelAction", cancelAction = new JButton());
        
        cancelAction.setName("cancelAction");
        cancelAction.setText(_("isisfish.common.cancel"));
        cancelAction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelAction"));
    }

    protected void createEmail() {
        $objectMap.put("email", email = new JTextField());
        
        email.setName("email");
        email.setColumns(15);
        email.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__email"));
    }

    protected void createEmailLabel() {
        $objectMap.put("emailLabel", emailLabel = new JLabel());
        
        emailLabel.setName("emailLabel");
        emailLabel.setText(_("isisfish.launch.email"));
    }

    protected void createFirstname() {
        $objectMap.put("firstname", firstname = new JTextField());
        
        firstname.setName("firstname");
        firstname.setColumns(15);
        firstname.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__firstname"));
    }

    protected void createFirstnameLabel() {
        $objectMap.put("firstnameLabel", firstnameLabel = new JLabel());
        
        firstnameLabel.setName("firstnameLabel");
        firstnameLabel.setText(_("isisfish.launch.firstname"));
    }

    protected void createHelpEditor() {
        $objectMap.put("helpEditor", helpEditor = new JEditorPane());
        
        helpEditor.setName("helpEditor");
        helpEditor.setEditable(false);
    }

    protected void createLasstname() {
        $objectMap.put("lasstname", lasstname = new JTextField());
        
        lasstname.setName("lasstname");
        lasstname.setColumns(15);
        lasstname.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__lasstname"));
    }

    protected void createLasstnameLabel() {
        $objectMap.put("lasstnameLabel", lasstnameLabel = new JLabel());
        
        lasstnameLabel.setName("lasstnameLabel");
        lasstnameLabel.setText(_("isisfish.launch.lasstname"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setEnabled(false);
        ok.setText(_("isisfish.common.apply"));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setText(_("isisfish.common.reset"));
        reset.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createServerAuthenticationMethodAnonymous() {
        $objectMap.put("serverAuthenticationMethodAnonymous", serverAuthenticationMethodAnonymous = new JRadioButton());
        
        serverAuthenticationMethodAnonymous.setName("serverAuthenticationMethodAnonymous");
        serverAuthenticationMethodAnonymous.setText(_("isisfish.launch.anonymous"));
        { serverAuthenticationMethodAnonymous.putClientProperty("$value", "anonymous");  Object $buttonGroup = serverAuthenticationMethodAnonymous.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        serverAuthenticationMethodAnonymous.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__serverAuthenticationMethodAnonymous"));
    }

    protected void createServerAuthenticationMethodLabel() {
        $objectMap.put("serverAuthenticationMethodLabel", serverAuthenticationMethodLabel = new JLabel());
        
        serverAuthenticationMethodLabel.setName("serverAuthenticationMethodLabel");
        serverAuthenticationMethodLabel.setText(_("isisfish.launch.server.authenticationMethod"));
    }

    protected void createServerAuthenticationMethodSsh() {
        $objectMap.put("serverAuthenticationMethodSsh", serverAuthenticationMethodSsh = new JRadioButton());
        
        serverAuthenticationMethodSsh.setName("serverAuthenticationMethodSsh");
        serverAuthenticationMethodSsh.setText(_("isisfish.launch.ssh"));
        { serverAuthenticationMethodSsh.putClientProperty("$value", "ssh");  Object $buttonGroup = serverAuthenticationMethodSsh.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        serverAuthenticationMethodSsh.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__serverAuthenticationMethodSsh"));
    }

    protected void createServerLogin() {
        $objectMap.put("serverLogin", serverLogin = new JTextField());
        
        serverLogin.setName("serverLogin");
        serverLogin.setColumns(15);
        serverLogin.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__serverLogin"));
    }

    protected void createServerLoginLabel() {
        $objectMap.put("serverLoginLabel", serverLoginLabel = new JLabel());
        
        serverLoginLabel.setName("serverLoginLabel");
        serverLoginLabel.setText(_("isisfish.launch.server.login"));
    }

    protected void createServerLoginNoPassPhraseLabel() {
        $objectMap.put("serverLoginNoPassPhraseLabel", serverLoginNoPassPhraseLabel = new JLabel());
        
        serverLoginNoPassPhraseLabel.setName("serverLoginNoPassPhraseLabel");
        serverLoginNoPassPhraseLabel.setText(_("isisfish.launch.server.ssh.no.passphrase"));
    }

    protected void createServerMethod() {
        $objectMap.put("serverMethod", serverMethod = new JAXXButtonGroup());
    }

    protected void createServerNoPassPhrase() {
        $objectMap.put("serverNoPassPhrase", serverNoPassPhrase = new JCheckBox());
        
        serverNoPassPhrase.setName("serverNoPassPhrase");
        serverNoPassPhrase.setSelected(true);
        serverNoPassPhrase.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__serverNoPassPhrase"));
    }

    protected void createServerPrivateKeyChangeFile() {
        $objectMap.put("serverPrivateKeyChangeFile", serverPrivateKeyChangeFile = new JButton());
        
        serverPrivateKeyChangeFile.setName("serverPrivateKeyChangeFile");
        serverPrivateKeyChangeFile.setText(_("isisfish.launch.server.ssh.key.change"));
    }

    protected void createServerPrivateKeyFile() {
        $objectMap.put("serverPrivateKeyFile", serverPrivateKeyFile = new JTextField());
        
        serverPrivateKeyFile.setName("serverPrivateKeyFile");
        serverPrivateKeyFile.setColumns(15);
        serverPrivateKeyFile.setColumns(28);
        if (serverPrivateKeyFile.getFont() != null) {
            serverPrivateKeyFile.setFont(serverPrivateKeyFile.getFont().deriveFont((float) 12));
        }
        SwingUtil.setComponentHeight(serverPrivateKeyFile,25);
        serverPrivateKeyFile.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__serverPrivateKeyFile"));
    }

    protected void createServerPrivateKeyFileLabel() {
        $objectMap.put("serverPrivateKeyFileLabel", serverPrivateKeyFileLabel = new JLabel());
        
        serverPrivateKeyFileLabel.setName("serverPrivateKeyFileLabel");
        serverPrivateKeyFileLabel.setText(_("isisfish.launch.server.ssh.privateKeyFile"));
    }

    protected void createServerPrivateKeyGenerate() {
        $objectMap.put("serverPrivateKeyGenerate", serverPrivateKeyGenerate = new JButton());
        
        serverPrivateKeyGenerate.setName("serverPrivateKeyGenerate");
        serverPrivateKeyGenerate.setText(_("isisfish.launch.server.ssh.key.generate"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(firstnameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(firstname, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(lasstnameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(lasstname, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(emailLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(email, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverAuthenticationMethodLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverLoginLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverLogin, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverLoginNoPassPhraseLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverNoPassPhrase, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverPrivateKeyFileLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverPrivateKeyFile, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(helpEditor);
        // inline complete setup of $JPanel0
        $JPanel0.add(serverAuthenticationMethodAnonymous);
        $JPanel0.add(serverAuthenticationMethodSsh);
        addChildrenToServerAuthenticationMethodAnonymous();
        addChildrenToServerAuthenticationMethodSsh();
        // inline complete setup of $JPanel1
        $JPanel1.add(serverPrivateKeyChangeFile);
        $JPanel1.add(serverPrivateKeyGenerate);
        // inline complete setup of $JPanel2
        $JPanel2.add(ok);
        $JPanel2.add(reset);
        $JPanel2.add(cancelAction);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        SwingUtil.setComponentHeight($JScrollPane0,60);
        createHelpEditor();
        createFirstnameLabel();
        createFirstname();
        createLasstnameLabel();
        createLasstname();
        createEmailLabel();
        createEmail();
        createServerAuthenticationMethodLabel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0, 2, 2, 2));
        createServerAuthenticationMethodAnonymous();
        createServerAuthenticationMethodSsh();
        createServerLoginLabel();
        createServerLogin();
        createServerLoginNoPassPhraseLabel();
        createServerNoPassPhrase();
        createServerPrivateKeyFileLabel();
        createServerPrivateKeyFile();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(0, 2, 2, 2));
        createServerPrivateKeyChangeFile();
        createServerPrivateKeyGenerate();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(0, 3, 2, 2));
        createOk();
        createReset();
        createCancelAction();
        createServerMethod();
        // inline creation of $JDialog0
        setName("$JDialog0");
        
        init();helpEditor.addHyperlinkListener(new HyperlinkListener() {
                public void hyperlinkUpdate(HyperlinkEvent he) {
                    if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
        
                        try {
                            URL u = he.getURL();
                            Desktop.getDesktop().browse(u.toURI());
                        } catch (Exception e) {
                            if (log.isWarnEnabled()) {
                                log.warn("Cannot open link (maybe defaut browser in not configured ?)");
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Error while opening link", e);
                            }
                        }
                    }
                }
            });// registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SERVER_LOGIN_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
                    serverAuthenticationMethodSsh.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    serverAuthenticationMethodSsh.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_LOGIN_LABEL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    serverLoginLabel.setEnabled(serverAuthenticationMethodSsh.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    serverAuthenticationMethodSsh.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_LOGIN_LABEL_ENABLED));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SERVER_LOGIN_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
                    serverAuthenticationMethodSsh.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    serverAuthenticationMethodSsh.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_LOGIN_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    serverLogin.setEnabled(serverAuthenticationMethodSsh.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    serverAuthenticationMethodSsh.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_LOGIN_ENABLED));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SERVER_LOGIN_NO_PASS_PHRASE_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
                    serverAuthenticationMethodSsh.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    serverAuthenticationMethodSsh.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_LOGIN_NO_PASS_PHRASE_LABEL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    serverLoginNoPassPhraseLabel.setEnabled(serverAuthenticationMethodSsh.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    serverAuthenticationMethodSsh.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_LOGIN_NO_PASS_PHRASE_LABEL_ENABLED));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SERVER_NO_PASS_PHRASE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
                    serverAuthenticationMethodSsh.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    serverAuthenticationMethodSsh.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_NO_PASS_PHRASE_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    serverNoPassPhrase.setEnabled(serverAuthenticationMethodSsh.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    serverAuthenticationMethodSsh.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_NO_PASS_PHRASE_ENABLED));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SERVER_PRIVATE_KEY_FILE_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
                    serverAuthenticationMethodSsh.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    serverAuthenticationMethodSsh.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_PRIVATE_KEY_FILE_LABEL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    serverPrivateKeyFileLabel.setEnabled(serverAuthenticationMethodSsh.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    serverAuthenticationMethodSsh.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_PRIVATE_KEY_FILE_LABEL_ENABLED));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SERVER_PRIVATE_KEY_FILE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
                    serverAuthenticationMethodSsh.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    serverAuthenticationMethodSsh.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_PRIVATE_KEY_FILE_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    serverPrivateKeyFile.setEnabled(serverAuthenticationMethodSsh.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    serverAuthenticationMethodSsh.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_PRIVATE_KEY_FILE_ENABLED));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SERVER_PRIVATE_KEY_CHANGE_FILE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
                    serverAuthenticationMethodSsh.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    serverAuthenticationMethodSsh.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_PRIVATE_KEY_CHANGE_FILE_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    serverPrivateKeyChangeFile.setEnabled(serverAuthenticationMethodSsh.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (serverAuthenticationMethodSsh != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    serverAuthenticationMethodSsh.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this, BINDING_SERVER_PRIVATE_KEY_CHANGE_FILE_ENABLED));
                }
            }
        
            public void $pr$u6(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}