/*
 * #%L
 * $Id: RuleChooserHandler.java 3529 2011-11-18 15:45:59Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.1/src/main/java/fr/ifremer/isisfish/ui/simulator/RuleChooserHandler.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersFactorTableCellEditor;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersFactorTableCellRenderer;
import fr.ifremer.isisfish.ui.widget.editor.ScriptParameterDialog;

/**
 * Handler for {@link RuleChooser class}.
 * 
 * @author chatellier
 * @version $Revision: 3529 $
 * 
 * Last update : $Date: 2011-11-18 16:45:59 +0100 (Fri, 18 Nov 2011) $
 * By : $Author: echatellier $
 */
public class RuleChooserHandler {

    /**
     * Get new instance for selected rules names and add it to {@link rulesList} list.
     * 
     * @param ruleChooser rule chooser ui
     */
    protected void addSelectedRules(RuleChooser ruleChooser) {
        Object[] availableRuleValues = ruleChooser.getAvailableRuleList().getSelectedValues();
        for (Object availableRuleValue : availableRuleValues) {
            String availableRuleName = (String)availableRuleValue;
            try {
                RuleStorage ruleStorage = RuleStorage.getRule(availableRuleName);
                Rule ruleTmp = ruleStorage.getNewRuleInstance();

                // add it after autoconfiguration (if enabled)
                ruleTmp = (Rule)ScriptParameterDialog.displayConfigurationFrame(ruleChooser, ruleTmp);
                if (ruleTmp != null) {
                    ruleChooser.getRulesList().add(ruleTmp);
                }
            } catch (IsisFishException ex) {
                throw new IsisFishRuntimeException("Can't add rule", ex);
            }
        }
        ruleChooser.getSelectedRulesListModel().setRules(ruleChooser.getRulesList());
    }
    
    /**
     * Remove selected rules for selected rules list.
     * 
     * @param ruleChooser rule chooser ui
     */
    protected void removeSelectedRules(RuleChooser ruleChooser) {
        SimulAction simulAction = ruleChooser.getContextValue(SimulAction.class);
        Object[] selectedRuleValues = ruleChooser.getSelectedRulesList().getSelectedValues();
        for (Object selectedRuleValue : selectedRuleValues) {

            // condition pour savoir si on est dans l'instance principal
            // de définition d'une simulation (hack)
            if (ruleChooser.isShowFactorColumn()) {
                int ruleIndex = ruleChooser.getRulesList().indexOf(selectedRuleValue);
                simulAction.preRemoveRule(ruleIndex);
                ruleChooser.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
            }

            // real rule remove
            ruleChooser.getRulesList().remove(selectedRuleValue);
        }
        ruleChooser.getSelectedRulesListModel().setRules(ruleChooser.getRulesList());
        ruleChooser.getSelectedRulesList().clearSelection();
    }
    
    /**
     * Clear selected rule list.
     * 
     * @param ruleChooser rule chooser ui
     */
    protected void clearAllRules(RuleChooser ruleChooser) {
        // condition pour savoir si on est dans l'instance principal
        // de définition d'une simulation (hack)
        if (ruleChooser.isShowFactorColumn()) {
            SimulAction simulAction = ruleChooser.getContextValue(SimulAction.class);
            for (Rule rule : ruleChooser.getRulesList()) {
                int ruleIndex = ruleChooser.getRulesList().indexOf(rule);
                simulAction.preRemoveRule(ruleIndex);
            }
            ruleChooser.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
        }
        ruleChooser.getRulesList().clear();
        ruleChooser.getSelectedRulesListModel().setRules(ruleChooser.getRulesList());
        ruleChooser.getSelectedRulesList().clearSelection();
    }
    
    /**
     * Display paramters table form single selected list.
     * 
     * @param ruleChooser rule chooser ui
     */
    protected void displayRuleParameters(RuleChooser ruleChooser) {
        Rule selectedRule = (Rule)ruleChooser.getSelectedRulesList().getSelectedValue();
        if (selectedRule != null) {
            ruleChooser.getSelectedRuleParameterTableModel().setScript(selectedRule);

            ScriptParametersTableCellRenderer cellRenderer = new ScriptParametersTableCellRenderer(selectedRule);
            ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
            
            
            ScriptParametersTableCellEditor cellEditor = new ScriptParametersTableCellEditor(selectedRule);
            cellEditor.setRegionStorage(ruleChooser.getContextValue(RegionStorage.class));
            ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(1).setCellEditor(cellEditor);
            
            if (ruleChooser.isShowFactorColumn()) {
                RuleParametersFactorTableCellRenderer sensitivityRenderer = new RuleParametersFactorTableCellRenderer(ruleChooser, selectedRule);
                ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(2).setCellRenderer(sensitivityRenderer);
                RuleParametersFactorTableCellEditor sensitivityEditor = new RuleParametersFactorTableCellEditor(ruleChooser, selectedRule);
                ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(2).setCellEditor(sensitivityEditor);
            }
        }
        else {
            ruleChooser.getSelectedRuleParameterTableModel().setScript(null);
        }
    }
}
