/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n._;

public class PopulationMigrationMigrationUI extends InputContentUI<Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_COEF_NON_VIDE = "coefNonVide";
    public static final String PROPERTY_GPOP_SELECTED = "gPopSelected";
    public static final String PROPERTY_POP_INFO = "popInfo";
    public static final String PROPERTY_ZONE_ARRIVAL_SELECTED = "zoneArrivalSelected";
    public static final String PROPERTY_ZONE_DEPART_SELECTED = "zoneDepartSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_ARRIVAL_ZONE_CHOOSER_ENABLED = "fieldPopulationMigrationMigrationArrivalZoneChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_COEFFICIENT_ENABLED = "fieldPopulationMigrationMigrationCoefficient.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_DEPARTURE_ZONE_CHOOSER_ENABLED = "fieldPopulationMigrationMigrationDepartureZoneChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_GROUP_CHOOSER_ENABLED = "fieldPopulationMigrationMigrationGroupChooser.enabled";
    public static final String BINDING_POPULATION_MIGRATION_MIGRATION_TABLE_ENABLED = "populationMigrationMigrationTable.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWS28TSRDumDxIwjOBCMQrQBYQgnF4CmTEIw4BZ50swoAQvtDjaduNxt1Nd08YOCB+Aj8B7lyQuHFCHDhz4IL2L6xWe+CKqG4/xhMm9mjtQ3s8Vd9XX1VXV/vdP2hESXT4CQ5DRwZM0wZxlm88fPiX+4RU9CJRFUmF5hI1P0MZlCmjSa/zXml0tFw08GwLns3zhuCMsC50rogmlH7uE1UnRGt0II6oKJUtdcy5UASyzdoRlcT65r9/M6+9V28zCIUC1O2GVGb7oaJMhosoQz2NpiDSGs76mNVAhqSsBnq3mnd5Hyu1ihvkKXqJxopoVGAJZBodSZ+y5bD4UGi0Y67ARKDznGlwv1+Y1yhXlQ6tStIg8K2oqlJVdwLqUOPo3OEi8LGmnK3Qmow/3C8IYalHNRp2CWYaHU8ig0hUU6K6yCLgmOCiwKpcozMpsSWCFWcGE7FsqYG9RHxoGgIl3Wmq55iKOguc+yAtcp16AaVaJFBK3QYYy67IY9p43JCSrmF/A5fJCifVVc4eUI+sMw273HsOYYyE0FHPYD+d5TuYEb8r6bl72PUJVH9PrF+a3tZmPPd1AJvnlovYJf78emL71jgd7PierlLie7027pbkgcjXOVdEanQoQYI5g9BVLl/gYZy9reSM+X00bjvVN3IeylalFWq7eCaWyT0S6iWDj3NOzC3yStAAAOS+txuhAeC0jeI3gWcTBF7oK7DZGIEkj6AHWiUy4GPJVTiXEORc3yCt3uodYhP2oJOnYzVaCLTmLO53WPSIZFsJNobLmsMCCmCngXXdLJKGTg3O+Yp9tA160wMPGacfhQPJ12w7Xm5ZJNoXaxmYn040P6MBN1RGIzKA19Dm5d9H7l0wNYftnnXD1hBa68+Z6W8f//6w1J6wUxB7d6Jr1wUBk09ILqC1qQm9vTleA0397AoWuTIaV/ZQ29tjf4KwUssM4iBec5YYuHMbqzpQjIx9//R55vHXTSizhCZ8jr0lbPwLaFzXJVSB+14orl23irY82wzrDqMNzj1hZkNgX7dd8bDGsy5lHuzs1RCqsD+hCh0p7viXH9Ol99fblRgCZXs3dI+qMfIIjVLmU0bsbdO6SBJvl0mhSODx6MJIukKGzPcR0Tpui3a9nZTqsDmeMK2uNKPPYg1t5gaaQK4GVLRJmKfVlJzm9bJZ/kxm+GNghhOpGO6apTQIQy8NJwdmmB84i3QMvTScHZjh/MBZpGPopeFieoYNNFwaOIt0DL2yyKU4rZPmjGK5wr3mv4n/TdVPzNWBC2IYfgHHN1w0OAwAAA==";
    private static final Log log = LogFactory.getLog(PopulationMigrationMigrationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected Population bean;
    protected Boolean coefNonVide;
    protected JAXXComboBox fieldPopulationMigrationMigrationArrivalZoneChooser;
    protected JTextField fieldPopulationMigrationMigrationCoefficient;
    protected JAXXComboBox fieldPopulationMigrationMigrationDepartureZoneChooser;
    protected JAXXComboBox fieldPopulationMigrationMigrationGroupChooser;
    protected Boolean gPopSelected;
    protected PopulationSeasonInfo popInfo;
    protected MatrixPanelEditor populationMigrationMigrationTable;
    protected JButton remove;
    protected Boolean zoneArrivalSelected;
    protected Boolean zoneDepartSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationMigrationMigrationUI $InputContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Document $Document0;
    private JLabel $JLabel2;
    private JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    populationMigrationMigrationTable.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    refreshPanel();
                }
            }
        });
    }
    
    protected void populationMigrationMigrationMatrixChanged(MatrixPanelEvent event) {
        if (getPopInfo() != null) {
             getPopInfo().setMigrationMatrix(populationMigrationMigrationTable.getMatrix().clone());
        }
    }
    public void init(PopulationSeasonInfo pi) {
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        //setPopInfo(null);
        //setPopInfo(pi);
    
        populationMigrationMigrationTable.setMatrix(getPopInfo().getMigrationMatrix().copy());
    }
    
    /*public void refresh() {
        Population population = getSaveVerifier().getEntity(Population.class);
        // setBean(null); is useless here
        setBean(population);
        
        refreshPanel();
    }*/
    
    public void refreshPanel(){
        setFieldPopulationMigrationMigrationGroupChooserModel();
        setFieldPopulationMigrationMigrationDepartureZoneChooserModel();
        setFieldPopulationMigrationMigrationArrivalZoneChooserModel();
    
        //setAddButton();
    }
    protected void setFieldPopulationMigrationMigrationGroupChooserModel(){
        if (getBean() != null && getBean().getPopulationGroup() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationMigrationGroupChooser,getBean().getPopulationGroup(), null, true);
        }
    }
    protected void setFieldPopulationMigrationMigrationDepartureZoneChooserModel(){
        if (getBean() != null && getBean().getPopulationZone() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationMigrationDepartureZoneChooser,getBean().getPopulationZone(), null, true);
        }
    }
    protected void setFieldPopulationMigrationMigrationArrivalZoneChooserModel(){
        if (getBean() != null && getBean().getPopulationZone() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationMigrationArrivalZoneChooser,getBean().getPopulationZone(), null, true);
        }
    }
    protected void add(){
        getAction().addMigration(getPopInfo(),
                (PopulationGroup) fieldPopulationMigrationMigrationGroupChooser.getSelectedItem(),
                (Zone) fieldPopulationMigrationMigrationDepartureZoneChooser.getSelectedItem(),
                (Zone) fieldPopulationMigrationMigrationArrivalZoneChooser.getSelectedItem(),
                Double.parseDouble(fieldPopulationMigrationMigrationCoefficient.getText()));
        populationMigrationMigrationTable.setMatrix(getPopInfo().getMigrationMatrix().clone());
    }
    protected void remove() {
      int row = populationMigrationMigrationTable.getTable().getSelectedRow();
      if (row != -1) {
          Object group = populationMigrationMigrationTable.getTable().getValueAt(row, 0);
          Object departure = populationMigrationMigrationTable.getTable().getValueAt(row, 1);
          Object arrival = populationMigrationMigrationTable.getTable().getValueAt(row, 2);
        
          MatrixND mat = getPopInfo().getMigrationMatrix().clone();
          mat.setValue(group, departure, arrival, 0);
          getPopInfo().setMigrationMatrix(mat);
          populationMigrationMigrationTable.setMatrix(getPopInfo().getMigrationMatrix().copy());
      }
    }
    /*protected void groupChanged(){
        setGPopSelected(fieldPopulationMigrationMigrationGroupChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void coefChanged(){
        setCoefNonVide(!fieldPopulationMigrationMigrationCoefficient.getText().equals(""));
        setAddButton();
    }
    protected void zoneDepartueChanged(){
        setZoneDepartSelected(fieldPopulationMigrationMigrationDepartureZoneChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void zoneArrivalChanged(){
        setZoneArrivalSelected(fieldPopulationMigrationMigrationArrivalZoneChooser.getSelectedItem() != null);
        setAddButton();
    }*/
    protected void setAddButton() {
        add.setEnabled(isActive() &&
            fieldPopulationMigrationMigrationGroupChooser.getSelectedItem() != null &&
            !fieldPopulationMigrationMigrationCoefficient.getText().equals("") &&
            fieldPopulationMigrationMigrationDepartureZoneChooser.getSelectedItem() != null &&
            fieldPopulationMigrationMigrationArrivalZoneChooser.getSelectedItem() != null);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationMigrationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationMigrationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationMigrationMigrationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationMigrationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationMigrationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationMigrationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationMigrationUI() {
        $initialize();
    }

    public PopulationMigrationMigrationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        add();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        remove();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAddButton();
    }

    public void doItemStateChanged__on__fieldPopulationMigrationMigrationArrivalZoneChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAddButton();
    }

    public void doItemStateChanged__on__fieldPopulationMigrationMigrationDepartureZoneChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAddButton();
    }

    public void doItemStateChanged__on__fieldPopulationMigrationMigrationGroupChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAddButton();
    }

    public void doMatrixChanged__on__populationMigrationMigrationTable(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationMigrationMigrationMatrixChanged(event);
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAddButton();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public Population getBean() {
        return bean;
    }

    public Boolean getCoefNonVide() {
        return coefNonVide;
    }

    public JAXXComboBox getFieldPopulationMigrationMigrationArrivalZoneChooser() {
        return fieldPopulationMigrationMigrationArrivalZoneChooser;
    }

    public JTextField getFieldPopulationMigrationMigrationCoefficient() {
        return fieldPopulationMigrationMigrationCoefficient;
    }

    public JAXXComboBox getFieldPopulationMigrationMigrationDepartureZoneChooser() {
        return fieldPopulationMigrationMigrationDepartureZoneChooser;
    }

    public JAXXComboBox getFieldPopulationMigrationMigrationGroupChooser() {
        return fieldPopulationMigrationMigrationGroupChooser;
    }

    public Boolean getGPopSelected() {
        return gPopSelected;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    public MatrixPanelEditor getPopulationMigrationMigrationTable() {
        return populationMigrationMigrationTable;
    }

    public JButton getRemove() {
        return remove;
    }

    public Boolean getZoneArrivalSelected() {
        return zoneArrivalSelected;
    }

    public Boolean getZoneDepartSelected() {
        return zoneDepartSelected;
    }

    public Boolean isCoefNonVide() {
        return coefNonVide !=null && coefNonVide;
    }

    public Boolean isGPopSelected() {
        return gPopSelected !=null && gPopSelected;
    }

    public Boolean isZoneArrivalSelected() {
        return zoneArrivalSelected !=null && zoneArrivalSelected;
    }

    public Boolean isZoneDepartSelected() {
        return zoneDepartSelected !=null && zoneDepartSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setCoefNonVide(Boolean coefNonVide) {
        Boolean oldValue = this.coefNonVide;
        this.coefNonVide = coefNonVide;
        firePropertyChange(PROPERTY_COEF_NON_VIDE, oldValue, coefNonVide);
    }

    public void setGPopSelected(Boolean gPopSelected) {
        Boolean oldValue = this.gPopSelected;
        this.gPopSelected = gPopSelected;
        firePropertyChange(PROPERTY_GPOP_SELECTED, oldValue, gPopSelected);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    public void setZoneArrivalSelected(Boolean zoneArrivalSelected) {
        Boolean oldValue = this.zoneArrivalSelected;
        this.zoneArrivalSelected = zoneArrivalSelected;
        firePropertyChange(PROPERTY_ZONE_ARRIVAL_SELECTED, oldValue, zoneArrivalSelected);
    }

    public void setZoneDepartSelected(Boolean zoneDepartSelected) {
        Boolean oldValue = this.zoneDepartSelected;
        this.zoneDepartSelected = zoneDepartSelected;
        firePropertyChange(PROPERTY_ZONE_DEPART_SELECTED, oldValue, zoneDepartSelected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setEnabled(false);
        add.setText(_("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCoefNonVide() {
        $objectMap.put("coefNonVide", coefNonVide = false);
    }

    protected void createFieldPopulationMigrationMigrationArrivalZoneChooser() {
        $objectMap.put("fieldPopulationMigrationMigrationArrivalZoneChooser", fieldPopulationMigrationMigrationArrivalZoneChooser = new JAXXComboBox());
        
        fieldPopulationMigrationMigrationArrivalZoneChooser.setName("fieldPopulationMigrationMigrationArrivalZoneChooser");
        fieldPopulationMigrationMigrationArrivalZoneChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationMigrationMigrationArrivalZoneChooser"));
    }

    protected void createFieldPopulationMigrationMigrationCoefficient() {
        $objectMap.put("fieldPopulationMigrationMigrationCoefficient", fieldPopulationMigrationMigrationCoefficient = new JTextField());
        
        fieldPopulationMigrationMigrationCoefficient.setName("fieldPopulationMigrationMigrationCoefficient");
        fieldPopulationMigrationMigrationCoefficient.setColumns(15);
    }

    protected void createFieldPopulationMigrationMigrationDepartureZoneChooser() {
        $objectMap.put("fieldPopulationMigrationMigrationDepartureZoneChooser", fieldPopulationMigrationMigrationDepartureZoneChooser = new JAXXComboBox());
        
        fieldPopulationMigrationMigrationDepartureZoneChooser.setName("fieldPopulationMigrationMigrationDepartureZoneChooser");
        fieldPopulationMigrationMigrationDepartureZoneChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationMigrationMigrationDepartureZoneChooser"));
    }

    protected void createFieldPopulationMigrationMigrationGroupChooser() {
        $objectMap.put("fieldPopulationMigrationMigrationGroupChooser", fieldPopulationMigrationMigrationGroupChooser = new JAXXComboBox());
        
        fieldPopulationMigrationMigrationGroupChooser.setName("fieldPopulationMigrationMigrationGroupChooser");
        fieldPopulationMigrationMigrationGroupChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationMigrationMigrationGroupChooser"));
    }

    protected void createGPopSelected() {
        $objectMap.put("gPopSelected", gPopSelected = false);
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    protected void createPopulationMigrationMigrationTable() {
        $objectMap.put("populationMigrationMigrationTable", populationMigrationMigrationTable = new MatrixPanelEditor());
        
        populationMigrationMigrationTable.setName("populationMigrationMigrationTable");
        populationMigrationMigrationTable.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__populationMigrationMigrationTable"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createZoneArrivalSelected() {
        $objectMap.put("zoneArrivalSelected", zoneArrivalSelected = false);
    }

    protected void createZoneDepartSelected() {
        $objectMap.put("zoneDepartSelected", zoneDepartSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationMigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationMigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationMigrationDepartureZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationMigrationArrivalZoneChooser, new GridBagConstraints(3, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(populationMigrationMigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        populationMigrationMigrationTable.setLinearModel(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        createGPopSelected();
        createZoneDepartSelected();
        createZoneArrivalSelected();
        createCoefNonVide();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.common.populationGroup"));
        createFieldPopulationMigrationMigrationGroupChooser();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.populationMigrationMigration.coefficient"));
        createFieldPopulationMigrationMigrationCoefficient();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = fieldPopulationMigrationMigrationCoefficient.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationMigrationMigration.departureZone"));
        createFieldPopulationMigrationMigrationDepartureZoneChooser();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationMigrationMigration.arrivalZone"));
        createFieldPopulationMigrationMigrationArrivalZoneChooser();
        createAdd();
        createPopulationMigrationMigrationTable();
        createRemove();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_GROUP_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationMigrationGroupChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_COEFFICIENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationMigrationCoefficient.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_DEPARTURE_ZONE_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationMigrationDepartureZoneChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_MIGRATION_ARRIVAL_ZONE_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationMigrationArrivalZoneChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_MIGRATION_TABLE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationMigrationMigrationTable.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isActive());
            }
        });
    }

}