/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationPlanContext.java 3445 2011-07-15 13:12:45Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.0/src/main/java/fr/ifremer/isisfish/simulator/SimulationPlanContext.java $
 * %%
 * Copyright (C) 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator;

import java.util.HashMap;
import java.util.Map;

import fr.ifremer.isisfish.datastore.SimulationStorage;

/**
 * Simulation plan context.java
 * 
 * Replace old {@code AnalysePlanContext}.
 *
 * @author poussin
 * @version $Revision: 3445 $
 *
 * Last update: $Date: 2011-07-15 15:12:45 +0200 (Fri, 15 Jul 2011) $
 * by : $Author: chatellier $
 */
public class SimulationPlanContext {

    /** Simulation id. */
    protected String id;

    /** Simulation plan number. */
    protected int number = 0;

    /** Simulation parameters. */
    protected SimulationParameter param;

    /** Additional context values. */
    protected Map<String, Object> values = new HashMap<String, Object>();

    public SimulationPlanContext(String id, SimulationParameter param) {
        this.id = id;
        this.param = param;
    }

    /**
     * Get id.
     * 
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * Get current simulation plan simulation count.
     * 
     * Warning, in after simulation, refer to generated simulation count,
     * not ended simulation number.
     * Depreciated, but no remove this method, it's just to not be used
     * by user script.
     * 
     * @return the number
     * 
     * @deprecated use {@code nextSimulation.getParameter().getSimulationPlanNumber()}
     */
    public int getNumber() {
        return number;
    }

    /**
     * Must be call when new simulation is generated from plan.
     */
    public void incNumber() {
        number++;
    }

    /**
     * Get simulation parameters.
     * 
     * @return simulation parameters
     */
    public SimulationParameter getParam() {
        return param;
    }

    /**
     * Get plan context value.
     * 
     * Used in script.
     * 
     * @param key key
     * @return value for key.
     */
    public Object getValue(String key) {
        return this.values.get(key);
    }

    /**
     * Set plan context value.
     * 
     * Used in script.
     * 
     * @param key key
     * @param value value
     */
    public void setValue(String key, Object value) {
        this.values.put(key, value);
    }

    /**
     * Get last simulation storage.
     * 
     * Used in script.
     * 
     * @return last simulation storage
     */
    public SimulationStorage getLastSimulation() {
        SimulationStorage result = getSimulation(getNumber() - 1);
        return result;
    }

    /**
     * Get {@link SimulationStorage} for specified simulation plan number.
     * 
     * @param number number
     * @return {@link SimulationStorage}
     */
    public SimulationStorage getSimulation(int number) {
        SimulationStorage result = null;
        if (0 <= number && number <= getNumber()) {
            result = SimulationStorage.getSimulation(id + "_" + number);
        }
        return result;
    }
}
