/*
 * #%L
 * IsisFish
 * 
 * $Id: PopulationGroupImpl.java 3432 2011-07-06 14:24:29Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.entities;

import static org.nuiton.i18n.I18n._;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.isisfish.types.Month;

/**
 * PopulationGroupImpl.
 *
 * Created: 3 janv. 2006 15:26:53
 *
 * @author poussin
 * @version $Revision: 3432 $
 *
 * Last update: $Date: 2011-07-06 16:24:29 +0200 (Wed, 06 Jul 2011) $
 * by : $Author: chatellier $
 */
public class PopulationGroupImpl extends PopulationGroupAbstract {

    /** Logger for this class. */
    private static final Log log = LogFactory.getLog(PopulationGroupImpl.class);

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /*
     * @see fr.ifremer.isisfish.entities.PopulationGroup#getAge()
     */
    @Override
    public double getAge() {
        double result = 0;
        if (getPopulation() != null && getPopulation().getSpecies() != null) {
            if (getPopulation().getSpecies().getAgeGroupType()) {
                result = super.getAge();
            } else {
                result = getPopulation().getAge(getLength(), this)
                        / Month.NUMBER_OF_MONTH;
            }
        }
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.PopulationGroup#getLongueurMin()
     */
    @Override
    public double getLength() {
        double result = 0;
        if (getPopulation() != null && getPopulation().getSpecies() != null) {
            if (!getPopulation().getSpecies().getAgeGroupType()) {
                result = (getMinLength() + getMaxLength()) / 2.0;
            } else {
                result = getPopulation().getLength(
                        getAge() * Month.NUMBER_OF_MONTH, this);
            }
        }
        return result;
    }

    @Override
    public boolean isInLength(double length) {
        boolean result = getMinLength() <= length && length <= getMaxLength();
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.PopulationGroup#getMeanWeight()
     */
    @Override
    public double getMeanWeight() {
        double result = 0;
        try {
            Equation eq = getPopulation().getMeanWeight();
            result = eq.evaluate("group", this);
        } catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn("Error in mean weight equation");
            }
            if (log.isDebugEnabled()) {
                log.debug("StackTrace", eee);
            }
        }
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.PopulationGroup#getNaturalDeathRate()
     */
    @Override
    public double getNaturalDeathRate(Zone zone) {
        double result = 0;
        try {
            Equation eq = getPopulation().getNaturalDeathRate();
            if (eq != null) {
                result = eq.evaluate("pop", this.getPopulation(), "group",
                        this, "zone", zone);
            }
        } catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn("Error in natural death rate equation");
            }
            if (log.isDebugEnabled()) {
                log.debug("StackTrace", eee);
            }
        }
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.PopulationGroup#getPrice()
     */
    @Override
    public double getPrice() {
        double result = 0;
        try {
            Equation eq = getPopulation().getPrice();
            if (eq != null) {
                result = eq.evaluate("group", this);
            }
        } catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn("Error in price equation");
            }
            if (log.isDebugEnabled()) {
                log.debug("StackTrace", eee);
            }
        }
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.PopulationGroup#getMaturityOgive()
     */
    @Override
    public double getMaturityOgive() {
        double result = 0;
        try {
            Equation eq = getPopulation().getMaturityOgiveEquation();
            if (eq != null) {
                result = eq.evaluate("group", this);
            }
        } catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn("Error in maturityOgive equation");
            }
            if (log.isDebugEnabled()) {
                log.debug("StackTrace", eee);
            }
        }
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.PopulationGroup#getReproductionRate()
     */
    @Override
    public double getReproductionRate() {
        double result = 0;
        try {
            Equation eq = getPopulation().getReproductionRateEquation();
            if (eq != null) {
                result = eq.evaluate("group", this);
            }
        } catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn("Error in reproductionRate equation");
            }
            if (log.isDebugEnabled()) {
                log.debug("StackTrace", eee);
            }
        }
        return result;
    }
    
    @Override
    public String toString() {
        return _("isisfish.populationGroup.toString", this.getPopulation(),
                this.getId());
    }
}
