/*
 * Decompiled with CFR 0.152.
 */
package scripts;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;

public class RuleUtil {
    private static Log log = LogFactory.getLog(RuleUtil.class);

    public static double getTotalCatchTons(SimulationContext context, Species species, TimeStep step) {
        double result = 0.0;
        for (Population pop : species.getPopulation()) {
            MatrixND mat = context.getPopulationMonitor().getHoldCatch(pop);
            if (mat == null) continue;
            mat = mat.copy();
            mat = mat.sumOverDim(0);
            mat = mat.sumOverDim(1);
            mat = mat.sumOverDim(3);
            List groups = pop.getPopulationGroup();
            int c = 0;
            while (c < groups.size()) {
                PopulationGroup group = (PopulationGroup)groups.get(c);
                double weight = group.getMeanWeight();
                result += mat.getValue(0, 0, c, 0) * weight / 1000.0;
                ++c;
            }
        }
        return result;
    }

    public static double getTotalCatchTonsPop(SimulationContext context, Population pop, TimeStep step) {
        double result = 0.0;
        MatrixND mat = context.getPopulationMonitor().getHoldCatch(pop);
        if (mat != null) {
            mat = mat.copy();
            mat = mat.sumOverDim(0);
            mat = mat.sumOverDim(1);
            mat = mat.sumOverDim(3);
            List groups = pop.getPopulationGroup();
            int c = 0;
            while (c < groups.size()) {
                PopulationGroup group = (PopulationGroup)groups.get(c);
                double weight = group.getMeanWeight();
                result += mat.getValue(0, 0, c, 0) * weight / 1000.0;
                ++c;
            }
        }
        return result;
    }
}

