/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;
import scripts.SiMatrix;

public class InterdictionEngin
extends AbstractRule {
    private static Log log = LogFactory.getLog(InterdictionEngin.class);
    @Doc(value="Prohibited gear")
    public Gear param_gear = null;
    @Doc(value="Begin date")
    public TimeStep param_beginStep = new TimeStep(0);
    @Doc(value="End date")
    public TimeStep param_endStep = new TimeStep(119);
    @Doc(value="Begin month")
    public Month param_beginMonth = Month.JANUARY;
    @Doc(value="do the doc of param endMonth")
    public Month param_endMonth = Month.DECEMBER;
    protected String[] necessaryResult = new String[0];

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Prohibited gear";
    }

    public void init(SimulationContext context) throws Exception {
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        log.info((Object)"condition fermeture zone");
        boolean result = true;
        Month mois = step.getMonth();
        log.info((Object)("mois:" + mois));
        if (this.param_beginMonth.getMonthNumber() > mois.getMonthNumber() || mois.getMonthNumber() > this.param_endMonth.getMonthNumber()) {
            result = false;
        } else {
            log.info((Object)"on est dans l'espace des mois possible");
            if (step.before(this.param_beginStep)) {
                result = false;
            } else if (step.after(this.param_endStep)) {
                result = false;
            } else if (!metier.getGear().equals(this.param_gear)) {
                result = false;
            }
        }
        return result;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        log.info((Object)("le metier vise par l'interdiction : " + metier));
        MetierMonitor metierMon = context.getMetierMonitor();
        metierMon.addforbiddenMetier(metier);
        SiMatrix siMatrix = SiMatrix.getSiMatrix(context);
        List<Strategy> strs = siMatrix.getStrategies(step);
        ArrayList<Strategy> ListeStrat = new ArrayList<Strategy>();
        for (Strategy str : strs) {
            double prop = str.getStrategyMonthInfo(step.getMonth()).getProportionMetier(metier);
            if (prop == 0.0) continue;
            ListeStrat.add(str);
        }
        for (Strategy Strat : ListeStrat) {
            StrategyMonthInfo StratMonthInfo = Strat.getStrategyMonthInfo(step.getMonth());
            ArrayList MetiersPossibles = new ArrayList(Strat.getSetOfVessels().getPossibleMetiers());
            Iterator effort = MetiersPossibles.iterator();
            while (effort.hasNext()) {
                Metier met = ((EffortDescription)effort.next()).getPossibleMetiers();
                if (StratMonthInfo.getProportionMetier(met) != 0.0 && !met.getGear().equals(metier.getGear()) && !met.getName().equalsIgnoreCase("nonActivite") && !metierMon.isForbidden(metier, step.getMonth())) continue;
                effort.remove();
            }
            if (MetiersPossibles.size() != 0) {
                int NbMetier = MetiersPossibles.size();
                for (EffortDescription effort2 : MetiersPossibles) {
                    Metier met = effort2.getPossibleMetiers();
                    double NouvelleProportion = StratMonthInfo.getProportionMetier(met) + StratMonthInfo.getProportionMetier(metier) / (double)NbMetier;
                    StratMonthInfo.setProportionMetier(met, NouvelleProportion);
                }
                StratMonthInfo.setProportionMetier(metier, 0.0);
                continue;
            }
            MatrixND matNonActivite = metierMon.getOrCreateNoActivity(step, ResultName.MATRIX_NO_ACTIVITY, siMatrix.getStrategies(step), siMatrix.getMetiers(step));
            matNonActivite.setValue((Object)Strat, (Object)metier, StratMonthInfo.getProportionMetier(metier));
            StratMonthInfo.setProportionMetier(metier, 0.0);
        }
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
    }
}

