/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierDAO;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import scripts.SiMatrix;

public class ChangementParamControlablePresimu
extends AbstractRule {
    private static Log log = LogFactory.getLog(ChangementParamControlablePresimu.class);
    @Doc(value="Zone de fermeture")
    public Zone param_zone = null;
    @Doc(value="Engin concern\u00e9s")
    public Gear param_gear = null;
    @Doc(value="Begin month")
    public Month param_beginMonth = Month.JANUARY;
    @Doc(value="End month")
    public Month param_endMonth = Month.DECEMBER;
    @Doc(value="New param controlable value")
    public String param_newParamValue = "80";
    protected String[] necessaryResult = new String[0];

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Change gear parameter value for all metier with this gear";
    }

    public void init(SimulationContext context) throws Exception {
        SiMatrix siMatrix = SiMatrix.getSiMatrix(context);
        Zone ZoneFermee = this.param_zone;
        Month MoisDeb = this.param_beginMonth;
        Month MoisFin = this.param_endMonth;
        String nouvelleValeurParam = this.param_newParamValue;
        Gear EnginInterdit = this.param_gear;
        log.info((Object)("nom de l'engin interdit " + EnginInterdit.getName()));
        FisheryRegion RegionSimu = RegionStorage.getFisheryRegion((TopiaContext)context.getDB());
        List ListeMetiers = RegionSimu.getMetier();
        List SaisonFermee = Month.getMonths((Month)MoisDeb, (Month)MoisFin);
        for (Metier metier : ListeMetiers) {
            log.info((Object)("metier examin\u00e9 " + metier.getName() + " son engin " + metier.getGear().getName()));
            if (!metier.getGear().equals(EnginInterdit)) {
                log.info((Object)"l engin du m\u00e9tier n est pas concern\u00e9");
                continue;
            }
            log.info((Object)"l engin du m\u00e9tier est bien concern\u00e9");
            if (ZoneFermee == null && Month.JANUARY.equals((Object)MoisDeb) && Month.DECEMBER.equals((Object)MoisFin)) {
                metier.setGearParameterValue(nouvelleValeurParam);
                log.info((Object)("aucune spatialisation ni saisonnalit\u00e9, on passe le Param Controlable a " + nouvelleValeurParam));
                continue;
            }
            List ListeSaisons = metier.getMetierSeasonInfo();
            for (MetierSeasonInfo saisonmetier : ListeSaisons) {
                List saison = saisonmetier.getMonths();
                int taille = 0;
                if (ZoneFermee != null) {
                    taille = siMatrix.nbCellInter(saisonmetier.getZone(), ZoneFermee);
                } else {
                    log.info((Object)"pas de s\u00e9lection de zone, toute la zone d'\u00e9tude est donc concern\u00e9e");
                }
                if (ZoneFermee != null && taille == 0 || !saison.containsAll(SaisonFermee)) continue;
                log.info((Object)("il y a intersection de la zone metier au cours de la saison" + saison));
                ArrayList moisconcerne = new ArrayList(saison);
                moisconcerne.retainAll(SaisonFermee);
                MetierDAO metierDao = IsisFishDAOHelper.getMetierDAO((TopiaContext)context.getDB());
                MetierSeasonInfoDAO infoDao = IsisFishDAOHelper.getMetierSeasonInfoDAO((TopiaContext)context.getDB());
                EffortDescriptionDAO effortDao = IsisFishDAOHelper.getEffortDescriptionDAO((TopiaContext)context.getDB());
                Metier NouveauMetier = (Metier)metierDao.create(new Object[0]);
                NouveauMetier.setName(String.valueOf(metier.getName()) + " Mois " + ((Month)moisconcerne.get(0)).getMonthNumber() + " a " + ((Month)moisconcerne.get(moisconcerne.size() - 1)).getMonthNumber() + " ValeurParam " + nouvelleValeurParam);
                NouveauMetier.setGear(EnginInterdit);
                NouveauMetier.setGearParameterValue(nouvelleValeurParam);
                NouveauMetier.setComment("m\u00e9tier cr\u00e9\u00e9 pendant la simu pour le changement de param\u00e8tre contr\u00f4lable");
                for (MetierSeasonInfo infsais : metier.getMetierSeasonInfo()) {
                    List sais = infsais.getMonths();
                    MetierSeasonInfo NouveauInfoSaison = (MetierSeasonInfo)infoDao.create(new Object[0]);
                    NouveauInfoSaison.setMetier(NouveauMetier);
                    NouveauInfoSaison.setMonths(sais);
                    NouveauInfoSaison.setZone(new ArrayList(infsais.getZone()));
                    NouveauInfoSaison.setComment("cr\u00e9\u00e9 durant la simulation");
                    NouveauMetier.addMetierSeasonInfo(NouveauInfoSaison);
                }
                List listestrategies = RegionSimu.getStrategy();
                for (Strategy strategie : listestrategies) {
                    SetOfVessels SetOfBateau = strategie.getSetOfVessels();
                    EffortDescription AncienEffort = SetOfBateau.getPossibleMetiers(metier);
                    if (AncienEffort == null) continue;
                    EffortDescription DescriptionEffort = (EffortDescription)effortDao.create(new Object[0]);
                    DescriptionEffort.setPossibleMetiers(NouveauMetier);
                    DescriptionEffort.setSetOfVessels(SetOfBateau);
                    DescriptionEffort.setFishingOperation(AncienEffort.getFishingOperation());
                    DescriptionEffort.setFishingOperationDuration(AncienEffort.getFishingOperationDuration());
                    DescriptionEffort.setGearsNumberPerOperation(AncienEffort.getGearsNumberPerOperation());
                    DescriptionEffort.setCrewSize(AncienEffort.getCrewSize());
                    DescriptionEffort.setUnitCostOfFishing(AncienEffort.getUnitCostOfFishing());
                    DescriptionEffort.setFixedCrewSalary(AncienEffort.getFixedCrewSalary());
                    DescriptionEffort.setCrewShareRate(AncienEffort.getCrewShareRate());
                    DescriptionEffort.setCrewFoodCost(AncienEffort.getCrewFoodCost());
                    DescriptionEffort.setRepairAndMaintenanceGearCost(AncienEffort.getRepairAndMaintenanceGearCost());
                    DescriptionEffort.setLandingCosts(AncienEffort.getLandingCosts());
                    DescriptionEffort.setOtherRunningCost(AncienEffort.getOtherRunningCost());
                    SetOfBateau.addPossibleMetiers(DescriptionEffort);
                    Month[] monthArray = Month.MONTH;
                    int n = Month.MONTH.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Month mois = monthArray[n2];
                        StrategyMonthInfo PropStratMois = strategie.getStrategyMonthInfo(mois);
                        double prop = PropStratMois.getProportionMetier(metier);
                        if (moisconcerne.contains(mois) && prop != 0.0) {
                            log.info((Object)("la strat\u00e9gie " + strategie.getName() + " pratique bien le metier " + metier.getName() + " au mois " + mois));
                            PropStratMois.setProportionMetier(NouveauMetier, prop);
                            PropStratMois.setProportionMetier(metier, 0.0);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        return false;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
    }
}

