/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.service.importdata.ImportDataResult;
import fr.ifremer.echobase.services.service.importdata.ImportException;
import fr.ifremer.echobase.services.service.importdata.configurations.ImportDataConfigurationSupport;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLaunchImport<M extends ImportDataConfigurationSupport, S extends EchoBaseServiceSupport>
extends AbstractWaitAndExecAction<M, S> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractLaunchImport.class);
    @Inject
    protected transient EchoBaseUserPersistenceContext persistenceContext;

    protected AbstractLaunchImport(Class<M> modelType, Class<S> serviceType) {
        super(modelType, serviceType);
    }

    protected String getSuccesMessage() {
        return this.t("echobase.info.importData.succeded", new Object[0]);
    }

    protected String getErrorMessage() {
        return this.t("echobase.info.importData.failed", new Object[0]);
    }

    protected abstract ImportDataResult<M> doImport(S var1, M var2, EchoBaseUser var3) throws ImportException;

    protected String getResultMessage(M model) {
        String message = this.t("echobase.message.importData.result", new Object[]{model.getActionTime(), model.getResultMessage()});
        if (log.isInfoEnabled()) {
            log.info((Object)("Result: " + message));
        }
        return message;
    }

    public String getActionResumeTitle() {
        return this.t("echobase.legend.importData.result.resume", new Object[0]);
    }

    protected void startAction(S service, M model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start imports for " + this.getModel()));
        }
        try {
            ImportDataResult importResult = this.doImport(service, model, this.getEchoBaseSession().getUser());
            model.setResultMessage(importResult.getImportSummary());
        }
        catch (Exception error) {
            log.error((Object)"Error during import", (Throwable)error);
            throw new ImportException("Error during import", (Throwable)error);
        }
    }

    protected void closeAction(M model) throws Exception {
        this.destroyModel(model);
    }
}

