/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.entities.EchoBaseUserTopiaPersistenceContext;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.services.AbstractEchobaseActionConfiguration;
import fr.ifremer.echobase.services.EchoBaseService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContext;

public abstract class AbstractWaitAndExecAction<M extends AbstractEchobaseActionConfiguration, S extends EchoBaseService>
extends EchoBaseActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private final Class<M> modelType;
    private final Class<S> serviceType;
    private M model;
    private ActionContext actionContext;
    private String result;

    public final String getResult() {
        return this.result;
    }

    public final Exception getError() {
        return this.model.getError();
    }

    public final String getErrorStack() {
        String errorStack = null;
        if (this.model.hasError()) {
            errorStack = ExceptionUtils.getStackTrace((Throwable)this.model.getError());
        }
        return errorStack;
    }

    protected AbstractWaitAndExecAction(Class<M> modelType, Class<S> serviceType) {
        this.modelType = modelType;
        this.serviceType = serviceType;
    }

    protected abstract void startAction(S var1, M var2) throws Exception;

    public abstract String getActionResumeTitle();

    protected abstract String getSuccesMessage();

    protected abstract String getErrorMessage();

    protected abstract String getResultMessage(M var1);

    public final M getModel() {
        return (M)this.model;
    }

    public void prepare() throws Exception {
        if (this.actionContext == null) {
            this.actionContext = ActionContext.getContext();
        } else {
            ActionContext.setContext((ActionContext)this.actionContext);
        }
        this.model = this.getEchoBaseSession().getActionConfiguration(this.modelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String result() throws Exception {
        try {
            if (this.model.hasError()) {
                this.addFlashError(this.getErrorMessage());
            } else {
                this.result = this.getResultMessage(this.model);
                this.addFlashMessage(this.getSuccesMessage());
            }
            String string = "success";
            return string;
        }
        finally {
            this.closeAction(this.model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String execute() throws Exception {
        this.model.beginAction();
        ActionContext.setContext((ActionContext)this.actionContext);
        EchoBaseUserTopiaPersistenceContext tx = this.getServiceContext().getEchoBaseUserApplicationContext().newPersistenceContext();
        try {
            this.getServiceContext().setEchoBaseUserPersistenceContext((EchoBaseUserPersistenceContext)tx);
            EchoBaseService service = this.getServiceContext().newService(this.serviceType);
            this.startAction(service, this.model);
        }
        catch (Exception e) {
            this.model.setError(e);
        }
        finally {
            this.model.endAction();
            EchoBaseEntityHelper.closeConnection((AbstractTopiaPersistenceContext)((AbstractTopiaPersistenceContext)tx));
        }
        return "success";
    }

    protected void closeAction(M model) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyModel(M model) throws IOException {
        try {
            model.destroy();
        }
        finally {
            this.getEchoBaseSession().removeActionConfiguration(this.modelType);
        }
    }
}

