/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.workingDb;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.DriverType;
import fr.ifremer.echobase.entities.WorkingDbConfiguration;
import fr.ifremer.echobase.services.service.DecoratorService;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryService;
import fr.ifremer.echobase.services.service.workingDb.WorkingDbConfigurationService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ParameterAware;

public abstract class AbstractWorkingDbAction
extends EchoBaseActionSupport
implements Preparable,
ParameterAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractWorkingDbAction.class);
    protected Map<String, String> confs;
    protected Map<String, String> driverTypes;
    protected WorkingDbConfiguration conf;
    private transient Map<String, String[]> parameters;
    @Inject
    protected transient WorkingDbConfigurationService workingDbConfigurationService;
    @Inject
    protected transient DecoratorService decoratorService;
    @Inject
    protected transient ExportQueryService exportQueryService;

    public boolean isNewConf() {
        return false;
    }

    public final Map<String, String> getConfs() {
        return this.confs;
    }

    public final WorkingDbConfiguration getConf() {
        if (this.conf == null) {
            this.conf = this.workingDbConfigurationService.newConfiguration();
        }
        return this.conf;
    }

    public Map<String, String> getDriverTypes() {
        return this.driverTypes;
    }

    public final boolean isConfExists() {
        return StringUtils.isNotBlank((CharSequence)this.getConf().getTopiaId());
    }

    public void prepare() throws Exception {
        String[] ids;
        String id;
        this.driverTypes = this.decoratorService.decorateEnums((Enum[])DriverType.values());
        this.confs = this.exportQueryService.loadSortAndDecorate(WorkingDbConfiguration.class);
        if (this.confs.isEmpty()) {
            this.addFlashMessage(this._("echobase.info.no.workingDbConfiguration.saved", new Object[0]));
        }
        String string = id = (ids = (String[])this.parameters.get("conf.topiaId")) == null || ids.length == 0 ? null : ids[0];
        if (!StringUtils.isEmpty(id)) {
            this.conf = this.workingDbConfigurationService.getEditableConf(id);
            if (log.isInfoEnabled()) {
                log.info((Object)("Selected conf " + this.conf.getUrl()));
            }
        }
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }
}

