/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportDb;

import fr.ifremer.echobase.services.service.exportdb.ExportDbConfiguration;
import fr.ifremer.echobase.services.service.exportdb.ExportDbService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class Export
extends AbstractWaitAndExecAction<ExportDbConfiguration, ExportDbService> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Export.class);

    public Export() {
        super(ExportDbConfiguration.class, ExportDbService.class);
    }

    protected void startAction(ExportDbService service, ExportDbConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start export db to file " + model.getFileName()));
        }
        service.doExport(model);
    }

    protected String getSuccesMessage() {
        return I18n.t((String)"echobase.info.exportDb.succeded", (Object[])new Object[0]);
    }

    protected String getErrorMessage() {
        return I18n.t((String)"echobase.info.exportDb.failed", (Object[])new Object[0]);
    }

    public String getActionResumeTitle() {
        return I18n.t((String)"echobase.legend.exportDb.resume", (Object[])new Object[0]);
    }

    protected String getResultMessage(ExportDbConfiguration model) {
        String exportType = I18n.t((String)model.getExportDbMode().getI18nKey(), (Object[])new Object[0]);
        String result = I18n.t((String)"echobase.message.exportDb.result", (Object[])new Object[]{exportType, model.getFileName(), model.getActionTime()});
        if (log.isInfoEnabled()) {
            log.info((Object)("Result: " + result));
        }
        return result;
    }
}

