/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.EchoBaseUserEntityEnum;
import fr.ifremer.echobase.persistence.EchoBaseDbMeta;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.nuiton.topia.persistence.metadata.ColumnMeta;
import org.nuiton.topia.persistence.metadata.TableMeta;

public abstract class AbstractLoadPage
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected EchoBaseUserEntityEnum entityType;
    protected Map<String, String> entityTypes;
    protected TableMeta<EchoBaseUserEntityEnum> tableMeta;
    @Inject
    protected transient DbEditorService dbEditorService;

    public void setEntityType(EchoBaseUserEntityEnum entityType) {
        this.entityType = entityType;
    }

    public EchoBaseUserEntityEnum getEntityType() {
        return this.entityType;
    }

    public Map<String, String> getEntityTypes() {
        return this.entityTypes;
    }

    public List<ColumnMeta> getColumnMetas() {
        return this.tableMeta.getColumns();
    }

    public void load() throws Exception {
        this.entityTypes = Maps.newTreeMap();
        EchoBaseDbMeta dbMeta = this.getEchoBaseApplicationContext().getDbMeta();
        for (TableMeta meta : dbMeta) {
            if (!dbMeta.isEditable(meta)) continue;
            String name = meta.getName();
            this.entityTypes.put(name, name);
        }
        if (this.entityType == null) {
            this.addFlashMessage(this._("echobase.info.no.table.selected", new Object[0]));
        } else {
            this.tableMeta = this.dbEditorService.getTableMeta(this.entityType);
        }
    }
}

