<%--
  #%L
  EchoBase :: UI
  
  $Id: configureResultsImport.jsp 692 2012-09-22 15:29:02Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.1/echobase-ui/src/main/webapp/WEB-INF/jsp/importData/configureResultsImport.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<title>
  Configuration <s:text name="echobase.common.importType.results"/>
</title>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<script type="text/javascript">

  jQuery(document).ready(function () {

    // to change form when mode is changed
    $('[name="model.importType"]').change(function (event) {
      $('[class~="importType"]').hide();
      $('#' + this.value).show();
      $('#' + this.value + ' .errorMessage').hide();
    });

    // show incoming mode
    var incomingVal = $('[name="model.importType"][checked="checked"]').val();
    $('#' + incomingVal).show();

    $.autoSelectVoyageAndDataProcessing(
      $('#voyageSelectBox'),
      $('#dataProcessingSelectBox'),
      '<s:url action="getDataProcessingsForVoyage" namespace="/importData"/>',
      '<s:property value="model.voyageId"/>',
      '<s:property value="model.dataProcessingId"/>'
    );
  });
</script>

<s:radio id='mode' key='model.importType' list="importTypes"
         cssClass="cleanBoth" required="true" template="myradiomap"
         label='%{getText("echobase.common.importType")}' />

<s:form id="RESULT_VOYAGE" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importType">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importData.html', null)}" target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.importType" value="RESULT_VOYAGE" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:label key="echobase.information.one.file.required" required="true"
             value=''/>

    <s:file key="lengthAgeKeyFile"
            label='%{getText("echobase.common.lengthAgeKeyFile")}'/>

    <s:file key="lengthWeightKeyFile"
            label='%{getText("echobase.common.lengthWeightKeyFile")}'/>

    <s:file key="echotypeFile"
            label='%{getText("echobase.common.echotypeFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>
  </fieldset>
  <br/>
  <s:submit action="configureResults-modeVoyage" key='echobase.action.import'/>
</s:form>

<s:form id="RESULT_ESDU" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importType">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importData.html', null)}" target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.importType" value="RESULT_ESDU" label=''/>

    <s:select id='voyageSelectBox' key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <sj:select id='dataProcessingSelectBox' key="model.dataProcessingId"
               required="true"
               label='%{getText("echobase.common.dataProcessing")}'/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:label key="echobase.information.one.file.required" required="true"
             value=''/>

    <s:file key="esduByEchotypeFile"
            label='%{getText("echobase.common.esduByEchotypeFile")}'/>

    <s:file key="esduByEchotypeAndSpeciesCategoryFile"
            label='%{getText("echobase.common.esduByEchotypeAndSpeciesCategoryFile")}'/>

    <s:file key="esduBySpeciesAndSizeCategoryFile"
            label='%{getText("echobase.common.esduBySpeciesAndSizeCategoryFile")}'/>

    <s:file key="esduBySpeciesAndAgeCategoryFile"
            label='%{getText("echobase.common.esduBySpeciesAndAgeCategoryFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>
  </fieldset>
  <br/>
  <s:submit action="configureResults-modeEsdu" key='echobase.action.import'/>
</s:form>

<s:form id="RESULT_REGION" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importType">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importData.html', null)}" target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.importType" value="RESULT_REGION" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:file key="regionsFile" required="true"
            label='%{getText("echobase.common.cellRegionsFile")}'/>

    <s:file key="regionAssociationFile" required="true"
            label='%{getText("echobase.common.cellRegionAssociationFile")}'/>

    <s:file key="regionResultFile" required="true"
            label='%{getText("echobase.common.cellRegionResultFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>
  </fieldset>
  <br/>
  <s:submit action="configureResults-modeRegion" key='echobase.action.import'/>
</s:form>

<s:form id="RESULT_MAP" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importType">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="%{getDocumentation('importData.html', null)}" target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:hidden key="model.importType" value="RESULT_MAP" label=''/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.resultLabel" size="40" required="true"
                 label='%{getText("echobase.common.resultLabel")}'/>

    <s:file key="mapsFile" required="true"
            label='%{getText("echobase.common.cellMapsFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>
  </fieldset>
  <br/>
  <s:submit action="configureResults-modeMap" key='echobase.action.import'/>
</s:form>
