/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.persistence.EchoBaseDbMeta;
import fr.ifremer.echobase.ui.EchoBaseSession;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class EchoBaseApplicationContext {
    private static final Log log = LogFactory.getLog(EchoBaseApplicationContext.class);
    private static final String APPLICATION_CONTEXT_PARAMETER = "echobaseApplicationContext";
    protected EchoBaseConfiguration configuration;
    protected EchoBaseDbMeta dbMeta;
    protected TopiaContext internalRootContext;
    protected Set<EchoBaseSession> sessions;
    protected boolean defaultUsersCreated;

    public static EchoBaseApplicationContext getApplicationContext(ActionContext actionContext) {
        Map application = actionContext.getApplication();
        EchoBaseApplicationContext result = (EchoBaseApplicationContext)application.get(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static EchoBaseApplicationContext getApplicationContext(ServletContext servletContext) {
        EchoBaseApplicationContext result = (EchoBaseApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static void setApplicationContext(ServletContext servletContext, EchoBaseApplicationContext applicationContext) {
        servletContext.setAttribute(APPLICATION_CONTEXT_PARAMETER, (Object)applicationContext);
    }

    public static void removeApplicationContext(ServletContext servletContext) {
        servletContext.removeAttribute(APPLICATION_CONTEXT_PARAMETER);
    }

    public Set<EchoBaseSession> getEchoBaseSessions() {
        return this.sessions;
    }

    public synchronized void registerEchoBaseSession(EchoBaseSession session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        if (this.sessions == null) {
            this.sessions = Sets.newHashSet();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Register user session for [" + session.getUser().getEmail() + "]"));
        }
        this.sessions.add(session);
    }

    public synchronized void destroyEchoBaseSession(EchoBaseSession session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        Preconditions.checkNotNull((Object)this.sessions);
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroy user session for [" + session.getUser().getEmail() + "]"));
        }
        this.sessions.remove(session);
        session.close();
    }

    public EchoBaseConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EchoBaseConfiguration configuration) {
        this.configuration = configuration;
    }

    public TopiaContext getInternalRootContext() {
        return this.internalRootContext;
    }

    public void setInternalRootContext(TopiaContext internalRootContext) {
        this.internalRootContext = internalRootContext;
    }

    public EchoBaseDbMeta getDbMeta() {
        return this.dbMeta;
    }

    public void setDbMeta(EchoBaseDbMeta dbMeta) {
        this.dbMeta = dbMeta;
    }

    public boolean isDefaultUsersCreated() {
        return this.defaultUsersCreated;
    }

    public void setDefaultUsersCreated(boolean defaultUsersCreated) {
        this.defaultUsersCreated = defaultUsersCreated;
    }
}

