/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.web.filter.TopiaTransactionFilter;

/*
 * Exception performing whole class analysis ignored.
 */
public class EchoBaseTopiaTransactionFilter
extends TopiaTransactionFilter {
    private static final Log log = LogFactory.getLog(EchoBaseTopiaTransactionFilter.class);

    protected TopiaContext beginTransaction(ServletRequest request) throws TopiaRuntimeException {
        EchoBaseApplicationContext applicationContext = EchoBaseActionSupport.getEchoBaseApplicationContext();
        TopiaContext rootContext = applicationContext.getRootContext();
        try {
            TopiaContext transaction = rootContext.beginTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starts a new echo transaction " + transaction));
            }
            return transaction;
        }
        catch (TopiaException eee) {
            throw new TopiaRuntimeException("Could not start transaction", (Throwable)eee);
        }
    }

    protected void onCloseTransaction(TopiaContext transaction) {
        EchoBaseTopiaTransactionFilter.closeConnection((TopiaContext)transaction);
    }

    public static void closeConnection(TopiaContext transaction) {
        if (transaction == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"no transaction to close");
            }
        } else if (transaction.isClosed()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("transaction " + transaction + " is already closed"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("closing transaction " + transaction));
            }
            try {
                Transaction tx = ((TopiaContextImplementor)transaction).getHibernate().getTransaction();
                if (!tx.wasCommitted() && !tx.wasRolledBack()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"rollback transaction!");
                    }
                    tx.rollback();
                }
                transaction.closeContext();
            }
            catch (TopiaException e) {
                throw new TopiaRuntimeException((Throwable)e);
            }
        }
    }
}

