<%--
  #%L
  EchoBase :: UI
  
  $Id: configureCommonImport.jsp 508 2012-04-06 20:36:22Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.6/echobase-ui/src/main/webapp/WEB-INF/jsp/importData/configureCommonImport.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>

<title>
  Configuration <s:text name="echobase.common.importMode.common"/>
</title>

<script type="text/javascript">

  jQuery(document).ready(function () {

    $('[name="model.importMode"]').change(function (event) {
      $('[class~="importMode"]').hide();
      $('#' + this.value).show();
      $('#' + this.value + ' .errorMessage').hide();
    });

    var incomingVal = $('[name="model.importMode"][checked="checked"]').val();
    $('#' + incomingVal).show();

  });
</script>

<s:radio id='mode' key='model.importMode' list="importModes"
         cssClass="cleanBoth"
         label='%{getText("echobase.common.importMode")}'
         required="true" template="myradiomap"/>

<hr/>

<%--Import mode = ALL--%>

<s:form id="ALL" namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <div class="cleanBoth help">
      <s:a href="http://maven-site.forge.codelutin.com/echobase/imports.html#Voyage__Transit__Transect"
           target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:select key="model.missionId" required="true"
              label='%{getText("echobase.common.mission")}'
              list="missions" headerKey="" headerValue=""/>
    <br/>

    <s:hidden key="model.importMode" value="ALL" label=''/>

    <s:select key="model.areaOfOperationId" required="true"
              label='%{getText("echobase.common.areaOfOperation")}'
              list="areaOfOperations" headerKey="" headerValue=""/>

    <s:textfield key="model.voyageDescription" size="80" required="true"
                 label='%{getText("echobase.common.voyageDescription")}'/>

    <s:textfield key="model.datum" size="80" required="true"
                 label='%{getText("echobase.common.datum")}'/>

    <s:textfield key="model.transitRelatedActivity" size="80" required="true"
                 label='%{getText("echobase.common.transitRelatedActivity")}'/>

    <s:textfield key="model.transectLicence" size="80" required="true"
                 label='%{getText("echobase.common.transectLicence")}'/>

    <s:textfield key="model.transectGeospatialVerticalPositive" size="80"
                 required="true"
                 label='%{getText("echobase.common.transectGeospatialVerticalPositive")}'/>

    <s:textfield key="model.transectBinUnitsPingAxis" size="80" required="true"
                 label='%{getText("echobase.common.transectBinUnitsPingAxis")}'/>

    <s:file key="voyageFile" required="true"
            label='%{getText("echobase.common.voyageFile")}'/>

    <s:file key="transitFile" required="true"
            label='%{getText("echobase.common.transitFile")}'/>

    <s:file key="transectFile" required="true"
            label='%{getText("echobase.common.transectFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>

  </fieldset>

  <br/>
  <s:submit action="configureCommon-modeAll" key='echobase.action.import'/>

</s:form>

<%--Import mode = TRANSECT --%>

<s:form id='TRANSECT' namespace="/importData" method="POST"
        enctype="multipart/form-data" cssClass="hidden importMode">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.importData.configure"/>
    </legend>

    <s:hidden key="model.importMode" value="TRANSECT" label=''/>

    <div class="cleanBoth help">
      <s:a href="http://maven-site.forge.codelutin.com/echobase/imports.html#Voyage__Transit__Transect"
           target="doc">
        <s:text name="echobase.action.show.import.documentation"/>
      </s:a>
    </div>
    <br/>

    <s:select key="model.voyageId" required="true"
              label='%{getText("echobase.common.voyage")}'
              list="voyages" headerKey="" headerValue=""/>

    <s:textfield key="model.datum" size="80" required="true"
                 label='%{getText("echobase.common.datum")}'/>

    <s:textfield key="model.transectLicence" size="80" required="true"
                 label='%{getText("echobase.common.transectLicence")}'/>

    <s:textfield key="model.transectGeospatialVerticalPositive" size="80"
                 required="true"
                 label='%{getText("echobase.common.transectGeospatialVerticalPositive")}'/>

    <s:textfield key="model.transectBinUnitsPingAxis" size="80" required="true"
                 label='%{getText("echobase.common.transectBinUnitsPingAxis")}'/>

    <s:file key="transectFile" required="true"
            label='%{getText("echobase.common.transectFile")}'/>

    <s:textarea key="model.importNotes" cols="80" rows="5"
                label='%{getText("echobase.common.importNotes")}'/>

  </fieldset>

  <br/>
  <s:submit action="configureCommon-modeTransect" key='echobase.action.import'/>


</s:form>