/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.Vessel;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.importdata.ResultsImportConfiguration;
import fr.ifremer.echobase.services.importdata.ResultsImportMode;
import fr.ifremer.echobase.ui.actions.importData.AbstractConfigureImport;
import java.io.File;
import java.util.Map;

public class ConfigureResults
extends AbstractConfigureImport<ResultsImportConfiguration> {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> voyages;
    protected Map<String, String> vessels;
    protected Map<String, String> importModes;
    protected String resultLabel;

    public ConfigureResults() {
        super(ResultsImportConfiguration.class);
    }

    protected ResultsImportConfiguration createModel() {
        return new ResultsImportConfiguration(this.getLocale());
    }

    public String input() throws Exception {
        super.input();
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.newService(EchoBaseServiceSupport.class);
        this.voyages = this.loadSortAndDecorate(service, Voyage.class);
        this.vessels = this.loadSortAndDecorate(service, Vessel.class);
        this.importModes = this.decorateEnums((Enum[])ResultsImportMode.values());
        if (((ResultsImportConfiguration)this.getModel()).getImportMode() == null) {
            ((ResultsImportConfiguration)this.getModel()).setImportMode(ResultsImportMode.VOYAGE);
        }
        return "input";
    }

    @InputConfig(methodName="input")
    public String modeVoyage() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeEsduByEchotype() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeEsduByEchotypeAndSpeciesCategory() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeEsduBySpeciesAndSizeCategory() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeEsduBySpeciesAndAgeCategory() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeRegion() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeMap() throws Exception {
        return this.execute();
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Map<String, String> getVessels() {
        return this.vessels;
    }

    public Map<String, String> getImportModes() {
        return this.importModes;
    }

    public String getResultLabel() {
        return this.resultLabel;
    }

    public void setResultLabel(String resultLabel) {
        this.resultLabel = resultLabel;
    }

    public void setRegionsFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getRegionsFile().setFile(file);
    }

    public void setRegionsFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getRegionsFile().setContentType(contentType);
    }

    public void setRegionsFileFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getRegionsFile().setFileName(fileName);
    }

    public void setRegionAssociationFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getRegionAssociationFile().setFile(file);
    }

    public void setRegionAssociationFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getRegionAssociationFile().setContentType(contentType);
    }

    public void setRegionAssociationFileFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getRegionAssociationFile().setFileName(fileName);
    }

    public void setRegionResultFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getRegionResultFile().setFile(file);
    }

    public void setRegionResultFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getRegionResultFile().setContentType(contentType);
    }

    public void setRegionResultFileFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getRegionResultFile().setFileName(fileName);
    }

    public void setMapsFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getMapsFile().setFile(file);
    }

    public void setMapsFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getMapsFile().setContentType(contentType);
    }

    public void setMapsFileFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getMapsFile().setFileName(fileName);
    }

    public void setLengthAgeKeyFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getLengthAgeKeyFile().setFile(file);
    }

    public void setLengthAgeKeyFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getLengthAgeKeyFile().setContentType(contentType);
    }

    public void setLengthAgeKeyFileFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getLengthAgeKeyFile().setFileName(fileName);
    }

    public void setLengthWeightKeyFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getLengthWeightKeyFile().setFile(file);
    }

    public void setLengthWeightKeyFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getLengthWeightKeyFile().setContentType(contentType);
    }

    public void setLengthWeightKeyFileFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getLengthWeightKeyFile().setFileName(fileName);
    }

    public void setEchotypeFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getEchotypeFile().setFile(file);
    }

    public void setEchotypeFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getEchotypeFile().setContentType(contentType);
    }

    public void setEchotypeFileFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getEchotypeFile().setFileName(fileName);
    }

    public void setEsduByEchotypeFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getEsduByEchotypeFile().setFile(file);
    }

    public void setEsduByEchotypeFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getEsduByEchotypeFile().setContentType(contentType);
    }

    public void setEsduByEchotypeFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getEsduByEchotypeFile().setFileName(fileName);
    }

    public void setEsduByEchotypeAndSpeciesCategoryFileFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getEsduByEchotypeAndSpeciesCategoryFile().setFile(file);
    }

    public void setEsduByEchotypeAndSpeciesCategoryFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getEsduByEchotypeAndSpeciesCategoryFile().setContentType(contentType);
    }

    public void setEsduByEchotypeAndSpeciesCategoryFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getEsduByEchotypeAndSpeciesCategoryFile().setFileName(fileName);
    }

    public void setEsduBySpeciesAndSizeCategoryFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getEsduBySpeciesAndSizeCategoryFile().setFile(file);
    }

    public void setEsduBySpeciesAndSizeCategoryFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getEsduBySpeciesAndSizeCategoryFile().setContentType(contentType);
    }

    public void setEsduBySpeciesAndSizeCategoryFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getEsduBySpeciesAndSizeCategoryFile().setFileName(fileName);
    }

    public void setEsduBySpeciesAndAgeCategoryFile(File file) {
        ((ResultsImportConfiguration)this.getModel()).getEsduBySpeciesAndAgeCategoryFile().setFile(file);
    }

    public void setEsduBySpeciesAndAgeCategoryFileContentType(String contentType) {
        ((ResultsImportConfiguration)this.getModel()).getEsduBySpeciesAndAgeCategoryFile().setContentType(contentType);
    }

    public void setEsduBySpeciesAndAgeCategoryFileName(String fileName) {
        ((ResultsImportConfiguration)this.getModel()).getEsduBySpeciesAndAgeCategoryFile().setFileName(fileName);
    }
}

