/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.EchoBaseTechnicalException;
import fr.ifremer.echobase.EchoBaseTopiaRootContextFactory;
import fr.ifremer.echobase.entities.EchoBaseUserImpl;
import fr.ifremer.echobase.entities.meta.DbMeta;
import fr.ifremer.echobase.services.DefaultEchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseServiceFactory;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import fr.ird.converter.FloatConverter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.util.converter.ConverterUtil;

public class EchoBaseApplicationListener
implements ServletContextListener {
    protected static final Log log = LogFactory.getLog(EchoBaseApplicationListener.class);
    private TopiaContext rootContext;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("echobase-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        EchoBaseApplicationContext applicationContext = new EchoBaseApplicationContext();
        sce.getServletContext().setAttribute("echoBaseApplicationContext", applicationContext);
        EchoBaseConfiguration configuration = new EchoBaseConfiguration();
        applicationContext.setConfiguration(configuration);
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing RootContext...");
        }
        EchoBaseTopiaRootContextFactory factory = new EchoBaseTopiaRootContextFactory();
        this.rootContext = factory.newDatabaseFromConfig(configuration);
        applicationContext.setRootContext(this.rootContext);
        DbMeta dbMeta = DbMeta.newDbMeta();
        applicationContext.setDbMeta(dbMeta);
        Converter converter = ConverterUtil.getConverter(Float.class);
        if (converter != null) {
            ConvertUtils.deregister(Float.class);
        }
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        try {
            boolean schemaExist = TopiaUtil.isSchemaExist((TopiaContext)this.rootContext, (String)EchoBaseUserImpl.class.getName());
            if (!schemaExist || configuration.getOptionAsBoolean("updateSchema")) {
                if (schemaExist) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Will update schema...");
                    }
                    this.rootContext.updateSchema();
                } else {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Will create schema...");
                    }
                    this.rootContext.createSchema();
                }
            }
            this.createAdminUser(applicationContext);
        }
        catch (TopiaException e) {
            throw new EchoBaseTechnicalException("Could not init db", (Throwable)e);
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        block6: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Application is ending at " + new Date() + "..."));
            }
            if (this.rootContext != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Shuting down RootContext...");
                }
                if (!this.rootContext.isClosed()) {
                    try {
                        this.rootContext.closeContext();
                    }
                    catch (TopiaException te) {
                        if (!log.isErrorEnabled()) break block6;
                        log.error((Object)"Could not close rootContext", (Throwable)te);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAdminUser(EchoBaseApplicationContext applicationContext) throws TopiaException {
        EchoBaseConfiguration configuration = applicationContext.getConfiguration();
        EchoBaseServiceFactory serviceFactory = new EchoBaseServiceFactory();
        TopiaContext transaction = this.rootContext.beginTransaction();
        try {
            EchoBaseServiceContext serviceContext = DefaultEchoBaseServiceContext.newContext((Locale)Locale.getDefault(), (TopiaContext)transaction, (EchoBaseConfiguration)configuration, (DbMeta)applicationContext.getDbMeta(), (EchoBaseServiceFactory)serviceFactory);
            UserService service = (UserService)serviceFactory.newService(UserService.class, serviceContext);
            List users = service.getUsers();
            if (CollectionUtils.isEmpty((Collection)users)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No user in database, will create default admin user (password admin).");
                }
                service.createDefaultUsers();
            }
        }
        finally {
            transaction.closeContext();
        }
    }

    protected void closeTransaction(TopiaContext tx) throws TopiaException {
        if (tx != null && !tx.isClosed()) {
            tx.closeContext();
        }
    }
}

