/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetUsers.java 297 2012-01-26 16:33:38Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.4/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/user/GetUsers.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.user;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;
import java.util.Map;

/**
 * Obtains all users of the echobase internal database.
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class GetUsers extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] users;

    public Map<String, Object>[] getUsers() {
        return users;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        List<EchoBaseUser> allUsers =
                newService(UserService.class).getUsers(pager);

        users = new Map[allUsers.size()];
        Binder<EchoBaseUser, EchoBaseUser> binder =
                BinderFactory.newBinder(EchoBaseUser.class);

        int index = 0;
        for (EchoBaseUser user : allUsers) {
            Map<String, Object> data = binder.obtainProperties(user);
            data.put("id", user.getTopiaId());
            users[index++] = data;
        }

        return SUCCESS;
    }

}
