/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: CreateMission.java 346 2012-03-10 00:54:19Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/CreateMission.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.base.Preconditions;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.entities.references.MissionImpl;
import fr.ifremer.echobase.services.exceptions.MissionNameAlreadyExistException;
import fr.ifremer.echobase.services.importdata.CommonDataImportService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * To create a new mission
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class CreateMission extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(CreateMission.class);

    /** Mission to create. */
    protected Mission mission;

    public Mission getMission() {
        if (mission == null) {
            mission = new MissionImpl();
        }
        return mission;
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(mission);

        String result = INPUT;

        try {
            CommonDataImportService service =
                    newService(CommonDataImportService.class);
            Mission missionSaved = service.createMission(mission);

            if (log.isInfoEnabled()) {
                log.info("Created mission : " + missionSaved.getTopiaId());
            }
            getTransaction().commitTransaction();
            addActionMessage(_("echobase.information.mission.created", missionSaved.getName()));
            result = SUCCESS;
        } catch (MissionNameAlreadyExistException e) {
            addFieldError("mission.name",
                          _("echobase.error.mission.name.already.exist"));
        }
        return result;
    }
}
