/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ConfigureAccousticData.java 318 2012-02-16 23:14:23Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/ConfigureAccousticData.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.configurations.AcousticDataImportConfiguration;
import fr.ifremer.echobase.services.configurations.CellPositionReference;

import java.io.File;
import java.util.Map;

/**
 * Configure a accoustic data import.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class ConfigureAccousticData extends AbstractConfigureImport<AcousticDataImportConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Universe of existing voyages. */
    protected Map<String, String> voyages;

    protected Map<String, String> cellPositionReferences;

    public ConfigureAccousticData() {
        super(AcousticDataImportConfiguration.class);
    }

    @Override
    protected AcousticDataImportConfiguration createModel() {
        return new AcousticDataImportConfiguration(getLocale());
    }

    @Override
    public String input() throws Exception {

        super.input();

        EchoBaseServiceSupport service =
                newService(EchoBaseServiceSupport.class);

        voyages = loadSortAndDecorate(service, Voyage.class);
        cellPositionReferences = decorateEnums(CellPositionReference.values());

        if (getModel().getCellPositionReference() == null) {

            getModel().setCellPositionReference(CellPositionReference.START);
        }

        return INPUT;
    }

    public Map<String, String> getVoyages() {
        return voyages;
    }

    public Map<String, String> getCellPositionReferences() {
        return cellPositionReferences;
    }

    public void setMoviesFile(File file) {
        getModel().getMoviesFile().setFile(file);
    }

    public void setMoviesFileContentType(String contentType) {
        getModel().getMoviesFile().setContentType(contentType);
    }

    public void setMoviesFileFileName(String fileName) {
        getModel().getMoviesFile().setFileName(fileName);
    }
}
