/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: Build.java 306 2012-02-04 09:20:28Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/embeddedApplication/Build.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.embeddedApplication;

import fr.ifremer.echobase.services.EmbeddedApplicationService;
import fr.ifremer.echobase.services.configurations.EmbeddedApplicationConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Build the embedded application archive.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class Build extends AbstractWaitAndExecAction<EmbeddedApplicationConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(Build.class);

    /** Service to build the embedded application archive. */
    protected transient EmbeddedApplicationService service;

    @Override
    protected EmbeddedApplicationConfiguration initModel() {
        return getEchoBaseSession().getEmbeddedApplicationConfiguration();
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();
        service = newService(EmbeddedApplicationService.class);
    }

    @Override
    protected void startAction(EmbeddedApplicationConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Start build of embedded application to file " +
                     model.getFileName());
        }

        service.createEmbeddedApplication(model);
    }

}