/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportDb;

import fr.ifremer.echobase.services.configurations.ExportDbConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class Configure
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);
    protected ExportDbConfiguration model;

    public ExportDbConfiguration getModel() {
        if (this.model == null) {
            this.model = new ExportDbConfiguration();
            this.model.setFileName("echobase");
        }
        return this.model;
    }

    public void setFileName(String fileName) {
        this.getModel().setFileName(fileName);
    }

    public String input() throws Exception {
        this.getEchoBaseSession().setExportDbConfiguration(null);
        return "input";
    }

    public String execute() throws Exception {
        ExportDbConfiguration configuration = this.getModel();
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-exportDb-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        configuration.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        this.getEchoBaseSession().setExportDbConfiguration(configuration);
        return "success";
    }
}

