/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.meta.ColumnMeta;
import fr.ifremer.echobase.entities.meta.DbMeta;
import fr.ifremer.echobase.entities.meta.TableMeta;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoadEntities
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String tableName;
    protected Map<String, String> tableNames;
    protected TableMeta tableMeta;

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, String> getTableNames() {
        return this.tableNames;
    }

    public List<ColumnMeta> getColumnMetas() {
        return this.tableMeta.getColumns();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String execute() throws Exception {
        this.tableNames = Maps.newTreeMap();
        DbMeta dbMeta = LoadEntities.getEchoBaseApplicationContext().getDbMeta();
        for (TableMeta tableMeta : dbMeta) {
            String name = tableMeta.getName();
            String i18nKey = tableMeta.getI18nKey();
            this.tableNames.put(name, I18n.l_((Locale)this.getLocale(), (String)i18nKey, (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)this.tableName)) {
            this.addActionMessage(this._("echobase.info.no.table.selected", new Object[0]));
        } else {
            DbEditorService dbEditorService = (DbEditorService)this.newService(DbEditorService.class);
            this.tableMeta = dbEditorService.getTableMetas(this.tableName);
        }
        return "success";
    }

    public String getEditType(ColumnMeta meta) {
        Class type = meta.getType();
        String editType = "text";
        if (Boolean.TYPE.equals(type)) {
            editType = "checkbox";
        } else if (TopiaEntity.class.isAssignableFrom(type)) {
            editType = "select";
        }
        return editType;
    }

    public String getFormatter(ColumnMeta meta) {
        Class type = meta.getType();
        String editType = "'string'";
        if (Boolean.TYPE.equals(type)) {
            editType = "'checkbox'";
        } else if (TopiaEntity.class.isAssignableFrom(type)) {
            editType = "'formatEntityLabel'";
        }
        return editType;
    }
}

