/*
 * #%L
 * $Id: MapAction.java 632 2011-02-01 13:19:15Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/coser/tags/coser-1.0/coser-web/src/main/java/fr/ifremer/coser/web/actions/map/MapAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Action index, recupere la liste des resultats.
 * 
 * @author chatellier
 * @version $Revision: 632 $
 * 
 * Last update : $Date: 2011-02-01 14:19:15 +0100 (mar., 01 févr. 2011) $
 * By : $Author: chatellier $
 */
public class MapAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1663244944108703571L;

    protected String facade;

    protected String survey;

    protected String species;

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getFacade() {
        return facade;
    }

    public String getSurvey() {
        return survey;
    }

    public void setSurvey(String survey) {
        this.survey = survey;
    }

    public String getSpecies() {
        return species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getFacades().get(facade);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", ex);
        }
        return displayName;
    }

    public String getSpeciesDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getSpeciesForSurvey(survey).get(species);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", ex);
        }
        return displayName;
    }
}
