package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import fr.ifremer.coselmar.persistence.DaoUtils;

public class QuestionTopiaDao extends AbstractQuestionTopiaDao<Question> {

    public List<Question> findForExpert(CoselmarUser expert) {

        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q "
            + " INNER JOIN Q." + Question.PROPERTY_PARTICIPANTS + " CUG ");

        Map<String, Object> args = new HashMap<>();

        String publicCondition = DaoUtils.getQueryForAttributeEquals("Q", Question.PROPERTY_PRIVACY, args, Privacy.PUBLIC, "");

        hqlBuilder.append(" WHERE (" + publicCondition + " ) ");

        String privateCondition = DaoUtils.getQueryForAttributeEquals("Q", Question.PROPERTY_PRIVACY, args, Privacy.PRIVATE, "");

        hqlBuilder.append(" OR (" + privateCondition);

        String userCondition = DaoUtils.andAttributeContains("CUG", CoselmarUserGroup.PROPERTY_MEMBERS, args, expert);

        hqlBuilder.append(userCondition + ")");

        List<Question> questions = forHql(hqlBuilder.toString(), args).findAll();

        return questions;
    }

    public List<String> findAllThemes() {

        StringBuilder hqlBuilder =
            new StringBuilder("SELECT DISTINCT(themes)"
                + " FROM " + Question.class.getName() + " Q "
                + " INNER JOIN Q." + Question.PROPERTY_THEME + " themes ");

        List<String> values = findAll(hqlBuilder.toString());

        return values;
    }

    public List<String> findAllTypes() {

        StringBuilder hqlBuilder =
            new StringBuilder("SELECT DISTINCT(Q. " + Question.PROPERTY_TYPE + ")"
                + " FROM " + Question.class.getName() + " Q ");

        List<String> values = findAll(hqlBuilder.toString());

        return values;
    }

} //QuestionTopiaDao
